<?php
	// strings should be static
	$strings = array(
		// big title
		'report_title' => 'Daily Report -',

		// summary
		'Panics' 		=> 'Panics',
		'Fatal Errors' 	=> 'Fatal Errors',
		'Warnings' 		=> 'Warnings',
		'summary_hint' 	=> '* To access the complete log report, please refer to the attachment.',

		// h2 titles
		'Grand Totals' 								=> 'Grand Totals',
		'Host/Domain Summary: Message Delivery' 	=> 'Top 10 Host/Domain Summary: Message Delivery',
		'Host/Domain Summary: Messages Received' 	=> 'Top 10 Host/Domain Summary: Message Received',
		'Senders by message count' 					=> 'Top 10 Senders by Message Count',
		'Recipients by message count' 				=> 'Top 10 Recipients by Message Count',
		'Senders by message size (bytes)' 			=> 'Top 10 Senders by Message Size (Bytes)',
		'Recipients by message size (bytes)' 		=> 'Top 10 Recipients by Message Size (Bytes)',

		// table labels	"cnt",
		'order'			=> 'No.',
		'cnt'			=> 'Count',
		'size'			=> 'Size',
		'status'		=> 'Status',
		'sent cnt'		=> 'Count',
		'bytes'			=> 'Size (Bytes)',
		'defers'		=> 'Defers',
		'avg dly'		=> 'Avg delay',
		'max dly'		=> 'Max delay',
		'host/domain'	=> 'Host/Domain',
		'msg cnt'		=> 'Count',
		'value'			=> 'Value',
		'email addr.'	=> 'Email address',
		'recipient'		=> 'Recipient',
	);
	function getString($k) {
		global $strings;
		if (array_key_exists($k, $strings)) {
			return $strings[$k];
		} else {
			return $k;
		}
	}

	if (2 != $argc) {
		echo "Usage: php " . $argv[0] . " report_json_file_name\n";
		return 0;
	}
	$input_str = file_get_contents($argv[1]);
	if (FALSE === $input_str) {
		syslog(LOG_ERR, "fail to load file content of " . $argv[1]);
		return -1;
	}

	$json_obj = json_decode($input_str, TRUE);
	if (NULL == $json_obj) {
		syslog(LOG_ERR, "fail to decode json content");
		return -1;
	}

	// these data are mostly from report
	// except 'color' & 'align' 
	$report_date = $json_obj['date'];
	$summary = array(
		array(
			'name' => 'Panics',
			'count' => $json_obj['panic_cnt'],
			'color' => '#000000'
		),
		array(
			'name' => 'Fatal Errors',
			'count' => $json_obj['fatal_cnt'],
			'color' => '#000000'
		),
		array(
			'name' => 'Warnings',
			'count' => $json_obj['warning_cnt'],
			'color' => '#000000'
		)
	);
	$reports = array(
		array(
			'name' => 'Grand Totals',
			'labels'=> [
				'cnt',
				'status'
			],
			'align' => [
				'right',
				'left'
			],
			'rows' => $json_obj['grand_total']
		),
		array(
			'name' => 'Host/Domain Summary: Message Delivered To',
			'labels'=> [
				'order',
				'host/domain',
				'sent cnt',
				'bytes',
				'defers',
				'avg dly',
				'max dly'
			],
			'align' => [
				'right',
				'left',
				'right',
				'right',
				'right',
				'right',
				'right'
			],
			'rows' => $json_obj['msg_delivery_summ']
		),
		array(
			'name' => 'Host/Domain Summary: Messages Received From',
			'labels'=> [
				'order',
				'host/domain',
				'msg cnt',
				'bytes'
			],
			'align' => [
				'right',
				'left',
				'right',
				'right'
			],
			'rows' =>  $json_obj['msg_received_summ']
		),
		array(
			'name' => 'Senders by message count',
			'labels'=> [
				'order',
				'email addr.',
				'cnt',
			],
			'align' => [
				'left',
				'left',
				'right'
			],
			'rows' => $json_obj['senders_by_msg_cnt']
		),
		array(
			'name' => 'Recipients by message count',
			'labels'=> [
				'order',
				'recipient',
				'cnt',
			],
			'align' => [
				'left',
				'left',
				'right'
			],
			'rows' => $json_obj['recipients_by_msg_cnt']
		),
		array(
			'name' => 'Senders by message size (bytes)',
			'labels'=> [
				'order',
				'email addr.',
				'size',
			],
			'align' => [
				'left',
				'left',
				'right'
			],
			'rows' => $json_obj['senders_by_msg_size']
		),
		array(
			'name' => 'Recipients by message size (bytes)',
			'labels'=> [
				'order',
				'recipient',
				'size'
			],
			'align' => [
				'left',
				'left',
				'right'
			],
			'rows' => $json_obj['recipients_by_msg_size']
		),
	);
?>
<html>
	<body style="margin: 0; border: 0; padding: 0; font-family: 'Helvetica Neue', Arial, Helvetica, san-serif;">
		<table bgcolor="#f1f2f3" style="width: 850px; border-collapse: collapse; background-color: #f1f2f3; border-bottom: 1px solid #d0d2d5;">
			<tr>
				<td style="padding: 5px 12px;">
					<img id="logo" src="data:image/png;base64,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">
				</td>
			</tr>
		</table>
		<table bgcolor="#fafafa" style="width: 850px; border-collapse: collapse;">
			<tr>
				<td style="font-family: 'Helvetica Neue', Arial, Helvetica, san-serif; font-size: 28px; color: #3c4650; font-weight:bold; padding: 16px 20px;">
					<?= getString('report_title') ?> <?= $report_date ?>
				</td>
			</tr>
			<tr>
				<td style="padding: 0 20px;">
					<table bgcolor="#e5f0f8" style="width: 100%; border-collapse: collapse; background-color: #e5f0f8;">
						<? foreach ($summary as $row): ?>
						<tr>
							<td style="font-family: 'Helvetica Neue', Arial, Helvetica, san-serif; font-size: 14px; font-weight:bold; color:#505a64; white-space: nowrap; padding: 10px 60px 0 12px;">
								<?= getString($row['name']) ?>
							</td>
							<td style="font-size: 14px; font-weight:bold; white-space: nowrap; text-align: right; color: <?= $row['color'] ?>; padding: 10px 12px 0;">
								<?= $row['count'] ?>
							</td>
							<td style="padding: 0; width: 100%"></td>
						</tr>
						<? endforeach; ?>
						<tr>
							<td colspan="3" style="font-family: 'Helvetica Neue', Arial, Helvetica, san-serif; font-size: 13px; color: #8b959d; padding: 16px 12px 10px;">
								<?= getString('summary_hint') ?>
							</td>
						</tr>
					</table>
				</td>
			</tr>
			<? foreach ($reports as $report): ?>
			<tr>
				<td style="padding: 10px;"></td>
			</tr>
			<tr>
				<td style="padding: 0 20px;">
					<table style="width: 100%; border-collapse: collapse;">
						<tr>
							<td style="font-family: 'Helvetica Neue', Arial, Helvetica, san-serif; font-size: 14px; color: #6b95b2; font-weight:bold; margin: 0; padding: 6px 12px; background-color: #f2f2f2;">
								<?= getString($report['name']) ?>
							</td>
						</tr>
						<tr>
							<td style="padding: 4px;"></td>
						</tr>
					</table>
					<table style="width: 100%; border-collapse: collapse; border-top: 1px solid #d7e1eb; border-bottom: 1px solid #d7e1eb;">
						<tr style="border-bottom: 1px solid #ebf0f5;">
							<? foreach ($report['labels'] as $i => $label): ?>
								<? if (0 === $i) { 
									if ("order" == $label) {
										$needOrder = TRUE;
									} else {
										$needOrder = FALSE;
									} ?>
									<td style="font-family: 'Helvetica Neue', Arial, Helvetica, san-serif; padding: 5px 24px; font-size: 14px; color: #0086e5; text-align: <?= $report['align'][$i] ?>; white-space: nowrap; font-weight:bold;">
										<?= getString($label) ?>
									</td>
								<? } else { ?>
									<td style="font-family: 'Helvetica Neue', Arial, Helvetica, san-serif; padding: 5px 24px; font-size: 14px; color: #0086e5; text-align: <?= $report['align'][$i] ?>; white-space: nowrap; font-weight:bold; border-left: 1px solid #ebf0f5;">
										<?= getString($label) ?>
									</td>
								<? } ?>
							<? endforeach; ?>
								<td style="width: 100%;"></td>
						</tr>
						<? foreach ($report['rows'] as $i => $row): ?>
						<tr style="border-bottom: 1px solid #ebf0f5;">
							<? foreach ($row as $j => $cell): ?>
								<? if (0 === $j) { ?>
									<? if (TRUE == $needOrder) { 
										$k = $j + 1; ?>
										<td style="font-family: 'Helvetica Neue', Arial, Helvetica, san-serif; padding: 5px 24px; font-size: 14px; color:#505a64; text-align: right; white-space: nowrap;">
											<? printf("%d", $i + 1) ?>
										</td>
									<? } else { 
										$k = $j; } ?>
									<td style="font-family: 'Helvetica Neue', Arial, Helvetica, san-serif; padding: 5px 24px; font-size: 14px; color:#505a64; text-align: <?= $report['align'][$k] ?>; white-space: nowrap;">
										<?= getString($cell) ?>
									</td>
								<? } else { ?>
									<td style="font-family: 'Helvetica Neue', Arial, Helvetica, san-serif; padding: 5px 24px; font-size: 14px; color:#505a64; text-align: <?= $report['align'][$k] ?>; white-space: nowrap;">
										<?= getString($cell) ?>
									</td>
								<? } 
								$k += 1; ?>
							<? endforeach; ?>
								<td style="width: 100%;"></td>
						</tr>
						<? endforeach; ?>
					</table>
				</td>
			</tr>
			<? endforeach; ?>
			<tr>
				<td style="padding: 10px;"></td>
			</tr>
		</table>
	</body>
</html>
