#!/usr/bin/env python
# -*- coding=utf8 -*-
import sys, os

def check_domain(domain):
    import re
    idna_domain = domain.decode('utf8').encode('idna')
    pattern = '^(?:[^\s`=~!@#$%^&*()_+\[\]\\{}|;:\'",\/<>?\.]+\.)*(?:[^\s`=~!@#$%^&*()_+\[\]\\{}|;:\'",\/<>?\.]+)$'
    return None != re.match(pattern, idna_domain)

def check_mail_addr(mail_addr):
    import re
    if mail_addr.find('@') == -1:
        return False
    username, domain = mail_addr.split('@', 1)
    usernameNotValid = '[\\\{\}\|\^\[\]\?\=\:\+\/\*\(\)\$\!"#%&\',;<>@`~]'
    usernameStart = '^[^\-\s\.]';
    usernameEnd = '\S$';

    if not check_domain(domain):
        return False
    if None != re.search(usernameNotValid, username) or None == re.match(usernameStart, username) or None == re.search(usernameEnd, username):
        return False
    return True

def check_file_path(file_path):
    if not os.path.isfile(file_path) or \
        os.path.realpath(file_path).find('/tmp/') != 0:
        return False
    return True

def validate_and_get_args():
    if len(sys.argv) < 5 or len(sys.argv) > 6:
        return
    domain_name = sys.argv[1]
    html_file_path = sys.argv[2]
    zip_file_path = sys.argv[3]
    recipients = sys.argv[4:]
    if not check_file_path(html_file_path) or not check_file_path(zip_file_path):
        return
    if not check_domain(domain_name):
        return
    for recipient in recipients:
        if not check_mail_addr(recipient):
            return
    map(lambda x: x.decode('utf8'), recipients)

    return (domain_name, html_file_path, zip_file_path, recipients)

def all_ascii(s):
    return all(ord(c) < 128 for c in s)

def main():
    import datetime, time
    from email.mime.multipart import MIMEMultipart
    from email.mime.text import MIMEText
    from email.mime.application import MIMEApplication
    from email import utils
    from email import utils
    from email.utils import formatdate

    try:
        domain_name, html_file_path, zip_file_path, recipients = validate_and_get_args()
    except:
        sys.stderr.write('invalid arguments\n')
        exit(1)

    date_yesterday = datetime.date.fromtimestamp(int(time.time()) - 86400)
    date_string = date_yesterday.strftime('%Y%m%d')
    subject = '{0} {1} daily report'.format(date_string, domain_name)

    msg = MIMEMultipart()

    msg['From'] = 'Reporter<reporter@{0}>'.format(domain_name)
    recipients_str = ', '.join(recipients)
    msg['To'] = recipients_str

    msg['Subject']= subject
    msg["Date"] = formatdate(localtime=True)
    msg['Message-ID'] = utils.make_msgid()

    with open(html_file_path, 'r') as html_file:
        html_content = html_file.read()
    text = MIMEText(html_content, 'html', 'utf8')
    msg.attach(text)

    attachment_name = "{0}_{1}.zip".format(date_string, domain_name)
    atta = MIMEApplication(open(zip_file_path, 'rb').read(), Name=attachment_name)
    atta['Content-Disposition'] = 'attachment; filename="{0}"'.format(attachment_name,)
    msg.attach(atta)

    print msg.as_string()

if __name__ == '__main__':
    ## usage: ./gen_mailplus_server_report.py domain_name html_file_path zip_file_path receiver1 receiver2
    main()
