#!/bin/sh
. /var/packages/MailPlus-Server/target/backend_hook/hookUtils.conf
loadEnv

## Actions
NODE_ID=$(${MAILPLUS_SERVER_BACKEND_BINARY} --getHostID)
CLUSTER_PEERS=($(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal cluster_peers))
REDIS_MASTER_NODE=${CLUSTER_PEERS[0]}
if [ -z "${NODE_ID}" ] || [ -z "${REDIS_MASTER_NODE}" ]; then
	err_log "[Change interface] empty NODE_ID or REDIS_MASTER_NODE"
	exit 1
fi

if containString "node_bind_if-${NODE_ID}" "${_MAIL_mailserver_trigger_events}"; then
	IF_NAME=$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "node_bind_if-${NODE_ID}")
	ORI_IP=$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "${NODE_ID}")
	IF_IP="$(getInterfaceIP "${IF_NAME}")"
	MASTER_IP="$(${BACKEND_BINARY} backend-command --command get_redis_master_ip)"

	if [ -z "${IF_IP}" ]; then
		err_log "[Change interface] cannot get ip of interface [${IF_NAME}]"
		exit 1
	fi

	if [ "${ORI_IP}" != "${IF_IP}" ]; then
		#update the id ip mapping info
		${BACKEND_BINARY} "backend-command" --command "set" --key "mapping_table/${NODE_ID}" "${IF_IP}"
		NEW_ORI_IP=$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "${NODE_ID}")
		for i in $(seq 1 1 10); do
			if [ "${NEW_ORI_IP}" == "${IF_IP}" ];then
				break
			fi
			err_log "[Change interface] - Wait for updating id-ip mapping..."
			sleep 1
			NEW_ORI_IP=$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "${NODE_ID}")
		done
	fi

	if [ "${NODE_ID}" == "${REDIS_MASTER_NODE}" ]; then
		#force to trigger watchers on all node to renew master_ip
		NODE_IP_LIST_KEY="general_config/node_ip_list-${NODE_ID}"
		NODE_IP_LIST_VALUE="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getHostIPList)"
		if ${BACKEND_BINARY} "backend-command" --command "set" --key "/tmp/new_master_ip" --value "${IF_IP}" --ttl "60"; then
			if ! ${BACKEND_BINARY} "backend-command" --command "set" --key "${NODE_IP_LIST_KEY}" --value "${NODE_IP_LIST_VALUE}"; then
				err_log "[Change interface] Failed to update node ip list [${NODE_IP_LIST_KEY}] to [${NODE_IP_LIST_VALUE}] when ip change"
			fi
		else
			err_log "[Change interface] Failed to set /tmp/new_master_ip"
		fi
	fi
fi

exit 0
