#!/bin/sh
. /var/packages/MailPlus-Server/target/backend_hook/hookUtils.conf
loadEnv

CA_DIR="/var/packages/MailPlus-Server/etc/syslog_ca/"
CA_FILE="${CA_DIR}ca.crt"

## Check identity
NODE_ID=$(getHostID)
mailer_servers="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "mailer")"
if ! containString "${NODE_ID}" "${mailer_servers}"; then
	exit 0
fi

## Actions
HASH_VALUE=$(openssl x509 -noout -hash -in ${CA_FILE} 2>/dev/null )

if [ ! -z "${HASH_VALUE}" ] ; then
	rm ${CA_DIR}*.0 #remove old link
	chmod 644 ${CA_FILE}
	ln -sf ${CA_FILE} "${CA_DIR}${HASH_VALUE}.0"
	/usr/syno/sbin/synoservice --reload syslog-ng
else
	err_log "compute hash value for ca file fail"
fi


exit 0
