#!/bin/sh

. /var/packages/MailPlus-Server/target/backend_hook/hookUtils.conf
loadEnv

## Check identity
nodeID=$(getHostID)
BALANCER_NODE=$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "balancer")
if ! containString "${nodeID}" "${BALANCER_NODE}"; then
	exit 0
fi

## Actions
if ! ${CALLBACK_BINARY} "updateMasterBalancer" "${_MAIL_mailserver_trigger_events}"; then
	err_log "Failed to callback updateMasterBalancer"
	exit 1
fi

exit 0
