[ ! -z ${MAILPLUS_SERVER_LOG_UTIL+MAILPLUS_SERVER_LOG_DEFINED} ] || . /var/packages/MailPlus-Server/target/scripts/MailPlusServerLogUtil.sh

MAIL_SERVER_PKG="/var/packages/MailPlus-Server"
MAILPLUS_SERVER_BACKEND_BINARY="${MAIL_SERVER_PKG}/target/bin/syno_mailserver_backend"
BACKEND_BINARY="${MAIL_SERVER_PKG}/target/usr/bin/syno-mailplus-server-go-utils"

SERVICE_NOT_RESTARTING=-1
SERVICE_RUNNING=0
SERVICE_NOT_RUNNING=1
SERVICE_DEAD_FPID=2
PORT_NOT_LISTEN=3
SERVICE_STARTING=4
SERVICE_UPDATING=5
SERVICE_UNKNOWN=6
PORT_LISTEN=7
SERVICE_INSTALLED=8
SERVICE_NOT_INSTALLED=9

RUNKEY_ENABLE=0
RUNKEY_DISABLE=1

MAX_TRY_TIMES=10
SLEEP_TIME=1

START_SUCCESSFUL=0
START_FAILED=1

checkConfKey() {
	local enable="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "$1")"
	if [ "yes" == "${enable}" ]; then
		return ${RUNKEY_ENABLE}
	else
		return ${RUNKEY_DISABLE}
	fi
}

checkProcessRun()
{
	local target_proc_name=$1
	#echo " checkProcessRun ---- ${target_proc_name}"
	if [ 0 != `ps -I | grep "${target_proc_name}" | grep -v "grep" | wc -l` ] ; then
		#echo "I'm running"
		return ${SERVICE_RUNNING}
	else
		#echo "I'm not running"
		return ${SERVICE_NOT_RUNNING}
	fi

}

checkServerStarted()
{
	local serverStatus="$(synopkg status MailPlus-Server | sed -n 1p)"
	if [[ "${serverStatus}" != *"started" ]]; then
		return ${SERVICE_NOT_RUNNING}
	fi
	return ${SERVICE_RUNNING}
}

#cannot check the process has different instance (Ex. director use dovecot binary, too)
checkPidFileStatus()
{
	local target_proc_name=$1
	local target_pid_file=$2
	local line=""
	#echo " checkPidFileStatus ----- ${target_proc_name} ---- ${target_pid_file} ----- "
	if [ x"`/bin/pidof "${target_proc_name}"`" != x"" ] ; then
		if [ -f "${target_pid_file}" ] ; then
			local pids=`cat "${target_pid_file}" | sed -e 's/-//'`
			for line in ${pids}; do
				if [ 0 != `ps -I | grep -F "${target_proc_name}" | grep "${line}" | wc -l` ] ; then
					#echo "I'm running"
					continue
				else
					#echo "I'm dead fpid"
					return ${SERVICE_DEAD_FPID}
				fi
			done
			return ${SERVICE_RUNNING}
		fi
		#echo "I don't have pid, but running"
		return ${SERVICE_RUNNING}
	else
		if [ -f "${target_pid_file}" ] ; then
			#echo "no run, but have pid"
			return ${SERVICE_DEAD_FPID}
		else
			#echo "I'm not running"
			return ${SERVICE_NOT_RUNNING}
		fi
	fi > /dev/null
}

checkPortUseStatus()
{
	local target_proc=$1
	local target_port=$2
	local target_ip=$3

	#echo " checkPortUseStatus ----- ${target_proc} ---- ${target_port} ----"
	if [ 0 != `netstat -nutlp | grep "${target_ip}:${target_port}" | grep "${target_proc}" | wc -l` ]; then
		#echo "I'm listening"
		return ${SERVICE_RUNNING}
	else
		#echo "I'm not get..."
		return ${PORT_NOT_LISTEN}
	fi > /dev/null
}

setSyncServDone()
{
	local serv=$1
	local hostID=
	hostID="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getHostID)"
	${MAILPLUS_SERVER_BACKEND_BINARY} --setServSyncDone "${serv}" "${hostID}"
}

get_lock()
{
	local timeout=30
	local lockPath="/var/lock/mailplus_server"
	local lockFile="${lockPath}/daemon.$1.lock"

	if [ ! -d "${lockPath}" ]; then
		checkServerStarted
		if [ $? -eq ${SERVICE_NOT_RUNNING} ]; then
			debug_log "Lock path isn't exist: ${lockPath}"
		else
			err_log "Lock path [${lockPath}] isn't exist, service call [$1] is not excuted."
		fi
		#Note Since bash exec redirect a non exist path, process will end and exit.
		#So we check dir path and exit if check fail to keep the behavior unchange.
		#Adding check path statement will prevent the bash error.
		exit 1
	fi
	#XXX after the package is stopped the director, /var/lock/mailplus_server, would be deleted,
	# and thus the following exec statement would fail, make the daemon not start when package is stopped
	exec 100>"${lockFile}"
	for i in `seq 1 $timeout`; do
		flock -x -n 100
		if [ 0 -eq $? ]; then
			return 0
		fi
		sleep 1
	done
	err_log "Get lock fail \"${lockFile}\""
	return 1
}

free_lock()
{
	local lockFile="/var/lock/mailplus_server/daemon.$1.lock"
	flock -u 100
}


restartBegin()
{
	local serv="$1"
	local timestamp="$(date +%s)"
	${BACKEND_BINARY} mailplus_server_command --restart_register --service_name "${serv}" --opt "${timestamp}"
}
restartEnd()
{
	local serv="$1"
	${BACKEND_BINARY} mailplus_server_command --restart_deregister --service_name "${serv}"
}
restartCheck()
{
	local serv="$1"
	local timeNow=
	local restartTime=
	local restartMaxTime=10

	if [ ! -e "/tmp/${serv}_restart" ]; then
		echo "${SERVICE_NOT_RESTARTING}"
		return 0
	fi

	restartTime=$(awk -F":" '{print $1}' < "/tmp/${serv}_restart")
	oldStatus=$(awk -F":" '{print $2}'< "/tmp/${serv}_restart")

	timeNow=$(date +%s)
	diff=$((timeNow - restartTime))

	if [ "${diff}" -gt "${restartMaxTime}" ]; then
		rm "/tmp/${serv}_restart"
		echo "${SERVICE_NOT_RESTARTING}"
	else
		echo "${oldStatus}"
	fi

	return 0
}

servRegister()
{
	local serv="$1"
	local opt="$2"
	${BACKEND_BINARY} mailplus_server_command --register --service_name "${serv}" --opt "${opt}"
}
servDeregister()
{
	local serv="$1"
	${BACKEND_BINARY} mailplus_server_command --deregister --service_name "${serv}"
}

function_exist()
{
	[ x$(type -t "$1") = xfunction ];
}

composeOperationOptStr()
{
	local opts=()
	local opt=""

	opt=$(composePID)
	if [ x"" != x"${opt}" ]; then
		local str="pid:${opt}"
		opts[${#opts[*]}]=${str}
	fi

	if function_exist "composeScript"; then
		opt=$(composeScript)
		if [ x"" != x"${opt}" ]; then
			local str="script:${opt}"
			opts[${#opts[*]}]=${str}
		fi
	fi

	if function_exist "composePort"; then
		opt=$(composePort)
		if [ x"" != x"${opt}" ]; then
			local str="ports:${opt}"
			opts[${#opts[*]}]=${str}
		fi
	fi

	if function_exist "composeIP"; then
		opt=$(composeIP)
		if [ x"" != x"${opt}" ]; then
			local str="ips:${opt}"
			opts[${#opts[*]}]=${str}
		fi
	fi

	if function_exist "composeProtocol"; then
		opt=$(composeProtocol)
		if [ x"" != x"${opt}" ]; then
			local str="protocol:${opt}"
			opts[${#opts[*]}]=${str}
		fi
	fi

	if function_exist "composeOpt"; then
		opt=$(composeOpt)
		if [ x"" != x"${opt}" ]; then
			local str="opt:${opt}"
			opts[${#opts[*]}]=${str}
		fi
	fi
	echo "$(IFS=\| ; echo "${opts[*]}")"
}

startOperation()
{
	local serv="$1"
	local opt=""

	get_lock "${serv}"
	start
	local start_status=$?

	if [ ${START_FAILED} -eq ${start_status} ]; then
		free_lock "${serv}"
		return ${start_status}
	fi

	opt=$(composeOperationOptStr)
	free_lock "${serv}"
	debug_log "${serv} start ---> ${opt}"
	servRegister "${serv}" "${opt}"
	setSyncServDone "${serv}"
}
stopOperation()
{
	local serv="$1"
	local opt=""

	get_lock "${serv}"
	stop
	free_lock "${serv}"
	debug_log "${serv} stop"
	servDeregister "${serv}"
	setSyncServDone "${serv}"
}
restartOperation()
{
	##FIXME: has to check if function exist
	local serv="$1"
	local opt=""
	local ret=

	restartBegin "${serv}"
	get_lock "${serv}"
	shift 2
	restart "$@"
	opt=$(composeOperationOptStr)
	free_lock "${serv}"
	debug_log "${serv} restart ---> ${opt}"

	restartEnd "${serv}"

	servRegister "${serv}" "${opt}"
	setSyncServDone "${serv}"
}
reloadOperation()
{
	local serv="$1"
	local opt=""
	local ret=

	restartBegin "${serv}"

	get_lock "${serv}"
	reload
	opt=$(composeOperationOptStr)
	free_lock "${serv}"
	debug_log "${serv} reload ---> ${opt}"

	restartEnd "${serv}"

	servRegister "${serv}" "${opt}"
	setSyncServDone "${serv}"
}
