#!/bin/sh

. /var/packages/MailPlus-Server/target/scripts/daemon/util.sh

NOTIFIER_BIN="${MAIL_SERVER_PKG}/target/sbin/syno_mailserver_notifierd"
NOTIFIER_PID="/var/run/mailplus_server/syno_mailserver_notifierd.pid"

bin_status()
{
	checkPidFileStatus "syno_mailserver_notifierd" "${NOTIFIER_PID}"
}

conf_status()
{
	checkConfKey "smtp_enabled"
	return $?
}

status()
{
	conf_status
	local notifierd_enable=$?
	bin_status
	local notifierd_status=$?

	if [ "${SERVICE_NOT_RUNNING}" -eq ${notifierd_status} ] && [ "${RUNKEY_DISABLE}" -ne "${notifierd_enable}" ]; then
		return "${SERVICE_UNKNOWN}"
	elif [ "${SERVICE_RUNNING}" -eq ${notifierd_status} ] && [ "${RUNKEY_ENABLE}" -ne "${notifierd_enable}" ]; then
		return "${SERVICE_UNKNOWN}"
	fi
	return ${notifierd_status}
}

start() {
	${NOTIFIER_BIN}

	local daemon_status=""
	for i in `seq 0 1 "${MAX_TRY_TIMES}"`
	do
		status
		daemon_status=$?
		debug_log "daemon_status syno_mailserver_notifierd: ${daemon_status}"
		if [ ${daemon_status} -eq "${SERVICE_RUNNING}" ]; then
			#binary is ready
			return ${START_SUCCESSFUL}
		elif [ ${daemon_status} -eq "${SERVICE_DEAD_FPID}" ]; then
			#[FIXME] Maybe we can do something to recover
			return ${START_FAILED}
		else
			sleep "${SLEEP_TIME}"
		fi
	done
	return ${START_FAILED}
}

stop() {
    kill `cat ${NOTIFIER_PID}` &> /dev/null
}

restart() {
	stop
	sleep 1
	start
}

reload() {
	echo "Reload syno_mailserver_notifierd..."
	bin_status
	ret=$?

	if [ ${ret} -eq "${SERVICE_NOT_RUNNING}" ]; then
		start
	else
		kill -s HUP `cat ${NOTIFIER_PID}`
	fi
}

composePID()
{
	local pid=$(cat ${NOTIFIER_PID} | sed -e 's/^[[:space:]]*//' -e 's/[[:space:]]*$//')
	echo "${pid}"
}

composeScript()
{
	echo "/var/packages/MailPlus-Server/target/scripts/daemon/syno_mailserver_notifierd.sh"
}


case "$1" in
	start)
		startOperation "mailserver_service_syno_mailserver_notifierd"
		;;
	restart)
		restartOperation "mailserver_service_syno_mailserver_notifierd"
		;;
	stop)
		stopOperation "mailserver_service_syno_mailserver_notifierd"
		;;
	reload)
		reloadOperation "mailserver_service_syno_mailserver_notifierd"
		;;
	status)
		status
		;;
	*)
		echo "Usage: $0 {start|stop|restart|reload|status}" >&2
		exit 1
		;;
esac
