#!/bin/sh

. /var/packages/MailPlus-Server/target/scripts/daemon/util.sh

DMARC_PID="/var/run/mailplus_server/opendmarc.pid"
DMARC_BIN="${MAIL_SERVER_PKG}/target/sbin/opendmarc"

bin_status()
{
	checkPidFileStatus "opendmarc" "${DMARC_PID}"
}

conf_status()
{
	checkConfKey "enable_dmarc"
	return $?
}

status()
{
	conf_status
	local opendmarc_enable=$?
	bin_status
	local opendmarc_status=$?

	if [ "${SERVICE_NOT_RUNNING}" -eq ${opendmarc_status} ] && [ "${RUNKEY_DISABLE}" -ne "${opendmarc_enable}" ]; then
		return "${SERVICE_UNKNOWN}"
	elif [ "${SERVICE_RUNNING}" -eq ${opendmarc_status} ] && [ "${RUNKEY_ENABLE}" -ne "${opendmarc_enable}" ]; then
		return "${SERVICE_UNKNOWN}"
	fi
	return ${opendmarc_status}
}

start()
{
	su MailPlus-Server -s /bin/sh -c "${DMARC_BIN}"

	local daemon_status=""
	for i in `seq 0 1 "${MAX_TRY_TIMES}"`
	do
		status
		daemon_status=$?
		debug_log "daemon_status opendmarc: ${daemon_status}"
		if [ ${daemon_status} -eq "${SERVICE_RUNNING}" ]; then
			#binary is ready
			return ${START_SUCCESSFUL}
		elif [ ${daemon_status} -eq "${SERVICE_DEAD_FPID}" ]; then
			#[FIXME] Maybe we can do something to recover
			return ${START_FAILED}
		else
			sleep "${SLEEP_TIME}"
		fi
	done
	return ${START_FAILED}
}
stop()
{
	kill `cat ${DMARC_PID}` &> /dev/null
	rm ${DMARC_PID} &> /dev/null
	local stop_success=0
	for i in `seq 0 1 "${MAX_TRY_TIMES}"`
	do
		bin_status
		local opendmarc_status=$?
		if [ "${SERVICE_NOT_RUNNING}" -eq ${opendmarc_status} ]; then
			stop_success=1
			break
		fi
		sleep "${SLEEP_TIME}"
	done
	if [ ${stop_success} -ne 1 ]; then
		debug_log "opendmarc not stop after trying ${MAX_TRY_TIMES} times"
	fi
}
restart()
{
	stop
	start
}


composePID()
{
	local pid=$(cat ${DMARC_PID} | sed -e 's/^[[:space:]]*//' -e 's/[[:space:]]*$//')
	echo "${pid}"
}

composeScript()
{
	echo "/var/packages/MailPlus-Server/target/scripts/daemon/opendmarc.sh"
}


case "$1" in
	start)
		startOperation "mailserver_service_opendmarc"
		;;
	restart)
		restartOperation "mailserver_service_opendmarc"
		;;
	stop)
		stopOperation "mailserver_service_opendmarc"
		;;
	status)
		status
		;;
	*)
		echo "Usage: $0 {start|stop|restart|status}" >&2
		exit 1
		;;
esac
