#!/bin/sh

. /var/packages/MailPlus-Server/target/scripts/daemon/util.sh
. /var/packages/MailPlus-Server/target/backend_hook/hookUtils.conf

HAPROXY_NAME="haproxy"
HAPROXY_BIN="${MAIL_SERVER_PKG}/target/sbin/haproxy"
HAPROXY_CONF="${MAIL_SERVER_PKG}/target/etc/synoMailPlusServerHaproxy.cfg"
HAPROXY_PID="/var/run/mailplus_server/mailplus_server_haproxy.pid"

bin_status()
{
	checkPidFileStatus "${HAPROXY_NAME}" "${HAPROXY_PID}"
	local haproxy_status=$?
	return ${haproxy_status}
}

port_status()
{
	local ports=`cat "${HAPROXY_CONF}" | grep -P "bind\s+" | awk -F":" '{print $2}' | awk -F" " '{print $1}'`
	local line=""
	for line in ${ports}; do
		if [ x"" == x"${line}" ] ; then
			return "${SERVICE_UNKNOWN}"
		fi
		checkPortUseStatus "${HAPROXY_NAME}" "${line}" "0.0.0.0"
		local port_status=$?
		if [ "${SERVICE_RUNNING}" -ne ${port_status} ] ; then
			return ${port_status}
		fi
	done

	return "${SERVICE_RUNNING}"
}

conf_status()
{
	checkConfKey "smtp_enabled"
	return $?
}

status()
{
	conf_status
	local haproxy_enable=$?
	bin_status
	local haproxy_status=$?

	if [ "${SERVICE_NOT_RUNNING}" -eq ${haproxy_status} ] && [ "${RUNKEY_DISABLE}" -ne "${haproxy_enable}" ]; then
		return "${SERVICE_UNKNOWN}"
	elif [ "${SERVICE_RUNNING}" -eq ${haproxy_status} ] && [ "${RUNKEY_ENABLE}" -ne "${haproxy_enable}" ]; then
		return "${SERVICE_UNKNOWN}"
	fi
	if [ "${SERVICE_RUNNING}" -ne ${haproxy_status} ]; then
		return ${haproxy_status}
	fi

	port_status
	local haproxy_port=$?
	return ${haproxy_port}
}

start() {
	echo "Starting HAProxy..."
	${HAPROXY_BIN} -D -f "${HAPROXY_CONF}" -p "${HAPROXY_PID}"

	local daemon_status=""
	for i in `seq 0 1 "${MAX_TRY_TIMES}"`
	do
		status
		daemon_status=$?
		debug_log "daemon_status haproxy: ${daemon_status}"
		if [ ${daemon_status} -eq "${SERVICE_RUNNING}" ]; then
			#binary is ready
			return ${START_SUCCESSFUL}
		elif [ ${daemon_status} -eq "${SERVICE_DEAD_FPID}" ]; then
			#[FIXME] Maybe we can do something to recover
			return ${START_FAILED}
		else
			sleep "${SLEEP_TIME}"
		fi
	done
	return ${START_FAILED}

}

stop(){
	[ -e ${HAPROXY_PID} ] || return 0
	local pid=$(cat ${HAPROXY_PID})
	kill "$pid" &> /dev/null
	rm ${HAPROXY_PID} &> /dev/null
}

restart()
{
	stop
	sleep 1
	start
}

composePort()
{
	local ports=()

	local haproxy_ports=`cat "${HAPROXY_CONF}" | grep "bind" | awk -F":" '{print $2}' | awk -F" " '{print $1}'`
	for port in ${haproxy_ports}; do
		if [ x"" == x"${port}" ] ; then
			continue
		fi
		ports[${#ports[*]}]=${port}
	done
	echo "$(IFS=, ; echo "${ports[*]}")"
}

composeIP()
{
	echo "0.0.0.0"
}

composeProtocol()
{
	echo "tcp"
}

composePID()
{
	local pid=$(cat ${HAPROXY_PID} | sed -e 's/^[[:space:]]*//' -e 's/[[:space:]]*$//')
	echo "${pid}"
}

composeScript()
{
	echo "/var/packages/MailPlus-Server/target/scripts/daemon/haproxy.sh"
}


case "$1" in
	start)
		startOperation "mailserver_service_haproxy"
		;;
	restart)
		restartOperation "mailserver_service_haproxy"
		;;
	stop)
		stopOperation "mailserver_service_haproxy"
		;;
	status)
		status
		;;
	*)
		echo "Usage: $0 {start|stop|restart|status}" >&2
		exit 1
		;;
esac
