#!/bin/sh
MAIL_SERVER_PKG="/var/packages/MailPlus-Server"
SPAM_ACCOUNT_MAILDIR="/var/spool/mail/@spamdata/autolearn/Maildir"
SPAM_ACCOUNT_SPAM_DIR_NEW="${SPAM_ACCOUNT_MAILDIR}/.Spam/new"
SPAM_ACCOUNT_SPAM_DIR_CUR="${SPAM_ACCOUNT_MAILDIR}/.Spam/cur"
SPAM_ACCOUNT_HAM_DIR_NEW="${SPAM_ACCOUNT_MAILDIR}/.Ham/new"
SPAM_ACCOUNT_HAM_DIR_CUR="${SPAM_ACCOUNT_MAILDIR}/.Ham/cur"
RSPAMC="${MAIL_SERVER_PKG}/target/bin/rspamc"

learnSpam()
{
	echo "Learning spam ..."

	if [ -d "${SPAM_ACCOUNT_SPAM_DIR_NEW}" ]; then
		echo "Learning spam/new ..."
		${RSPAMC} -c bayes learn_spam ${SPAM_ACCOUNT_SPAM_DIR_NEW} 2>&1
	fi

	if [ -d "${SPAM_ACCOUNT_SPAM_DIR_CUR}" ]; then
		echo "Learning spam/cur ..."
		${RSPAMC} -c bayes learn_spam ${SPAM_ACCOUNT_SPAM_DIR_CUR} 2>&1
	fi
}

learnHam()
{
	echo "Learning ham ..."

	if [ -d "${SPAM_ACCOUNT_HAM_DIR_NEW}" ]; then
		echo "Learning ham/new ..."
		${RSPAMC} -c bayes learn_ham ${SPAM_ACCOUNT_HAM_DIR_NEW} 2>&1
	fi

	if [ -d "${SPAM_ACCOUNT_HAM_DIR_CUR}" ]; then
		echo "Learning ham/cur ..."
		${RSPAMC} -c bayes learn_ham ${SPAM_ACCOUNT_HAM_DIR_CUR} 2>&1
	fi
}

cleanOldData()
{
	echo "Cleaning old training data ..."

	if [ -d "${SPAM_ACCOUNT_MAILDIR}" ]; then
		find ${SPAM_ACCOUNT_MAILDIR} ! -name "dovecot*" ! -name "maildirfolder" -type f -mtime +3 -exec rm {} \;
	fi
}

learnSpam
learnHam
cleanOldData
