#!/bin/sh
. /var/packages/MailPlus-Server/target/backend_hook/hookUtils.conf

MAILPLUS_SERVER_IP_CHANGE_LOCK_FILE="/tmp/mailplus_server/ip_post_change.lock"

hookPreCheck()
{
	# do nothing when interface change on shutdown step
	if /usr/syno/bin/synobootseq --is-shutdown > /dev/null 2>&1 ; then
		exit 0
	fi
	# do nothing when booting, we'll run this in upstart when booting is done.
	if /usr/syno/bin/synobootseq --is-booting-up > /dev/null 2>&1 ; then
		exit 0
	fi
}

updateNodeList()
{
	local nodeID="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getHostID)"
	local nodeIPList="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getHostIPList)"
	local key="node_ip_list-${nodeID}"

	nodeIPList=$(echo "${nodeIPList}" | sed -e "s/${ORIGIN_ADDRESS}\>/${NEW_ADDRESS}/")

	## Remove execute command flag
	rm -fr "${FIREWALL_REFRESH_FLAG}"

	info_log "[MailPlusServerIPChange] - start updateNodeList"
	if ! ${MAILPLUS_SERVER_BACKEND_BINARY} --setConfKeyVal "${key}" "${nodeIPList}"; then
		 err_log "[MailPlusServerIPChange] - Failed to update node ip list [${key}] to [${nodeIPList}] when ip change"
	fi

	local hostIP=$(getHostIP)
	if [ "${ORIGIN_ADDRESS}" == "${hostIP}" ]; then
		for i in $(seq 1 1 10); do
			if [ -e "${FIREWALL_REFRESH_FLAG}" ];then
				rm -fr "${FIREWALL_REFRESH_FLAG}"
				break
			fi
			info_log "[MailPlusServerIPChange] - Wait for firewall refresh..."
			sleep 1
		done
	fi
	info_log "[MailPlusServerIPChange] - done updateNodeList"
}

updateBackendCheck()
{
	## Check if ip is mailplus server used ip
	local hostIP=$(getHostIP)
	if [ "${ORIGIN_ADDRESS}" != "${hostIP}" ]; then
		return 1
	fi
	return 0
}
updateBackendPre()
{
	if ! updateBackendCheck; then
		return 0
	fi

	info_log "[MailPlusServerIPChange] - start updateBackendPre"
	## Notify new master IP, NOTICE: here load balancer equal redis master
	local masterIP="$(${BACKEND_BINARY} backend-command --command get_redis_master_ip)"
	if [ "${ORIGIN_ADDRESS}" == "${masterIP}" ] ; then
		${BACKEND_BINARY} "backend-command" --command "set" --key "/tmp/new_master_ip" --value "${NEW_ADDRESS}" --ttl "60"
	else
		${BACKEND_BINARY} "backend-command" --command "del" --key "/tmp/new_master_ip"
	fi
	info_log "[MailPlusServerIPChange] - done updateBackendPre"
}
updateBackendPost()
{
	if ! updateBackendCheck; then
		return 0
	fi

	local newHostIP="${NEW_ADDRESS}"
	info_log "[MailPlusServerIPChange] - start updateBackendPost [${newHostIP}]"

	## update certificate have to before mappingRegen to avoid get old certificate
	if ! GenerateInternalCert "onlyCert"; then
		err_log "[MailPlusServerIPChange] - Failed to regen certificate according new IP"
	fi

	## update backend config and mapping table
	if ! ${MAILPLUS_SERVER_BACKEND_BINARY} --mappingRegen "${newHostIP}"; then
		err_log "[MailPlusServerIPChange] - Failed to regen mailplus server id-ip mapping table"
	fi
	info_log "[MailPlusServerIPChange] - done updateBackendPost"
}

case $1 in
	--sdk-mod-ver)
	#Print SDK support version
	echo "1.0";
	;;
	--name)
	#Print package name
	echo "MailPlus-Server";
	;;
	--pkg-ver)
	#Print package version
	echo "1.0";
	;;
	--vendor)
	#Print package vendor
	echo "Synology";
	;;
	--pre)
		hookPreCheck

		updateBackendPre
		updateNodeList
	;;
	--post)
		hookPreCheck
		if ! $MAILPLUS_SERVER_BACKEND_BINARY --isIFStatic "${IFNAME}"; then
			#interface is not static, and thus may not trigger pre event
			updateBackendPre
			updateNodeList
		fi
		(
		if flock -n -x 8; then
			## avoid exec many times when encounter series net interface change event
			sleep 1
			flock -u 8
			rm ${MAILPLUS_SERVER_IP_CHANGE_LOCK_FILE}

			updateBackendPost
		fi
		)8> ${MAILPLUS_SERVER_IP_CHANGE_LOCK_FILE} &
	;;
	*)
	echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
	;;
esac

