#!/bin/sh

. /var/packages/MailPlus-Server/target/scripts/MailPlusServerCommon
. /var/packages/MailPlus-Server/target/scripts/daemon/util.sh

SYNO_MAILPLUS_SERVERD_SCRIPT="/var/packages/MailPlus-Server/target/scripts/daemon/syno_mailserverd.sh"

HOOK_DIR="/var/packages/MailPlus-Server/target/hook"
DIR_SRV_HOOK="${HOOK_DIR}/dir_service_hook"

case $1 in
	--sdk-mod-ver)
		${DIR_SRV_HOOK} --sdk-mod-ver;
		;;
	--name)
		#Print package name
		echo "${MAIL_SERVER_PKG_NAME}";
		;;
	--vendor)
		#Print package vendor
		echo "${MAIL_SERVER_PKG_VERSION}";
		;;
	--pre)
		${DIR_SRV_HOOK} --pre-leave
		;;
	--post)
		${DIR_SRV_HOOK} --post-leave

		#check if the package is enabled
		if [ ! -e "${MAIL_SERVER_PKG_ENABLE}" ]; then
			exit 0;
		fi

		#check if syno_mailserverd is running. If not start it
		${SYNO_MAILPLUS_SERVERD_SCRIPT} status
		if [ "${SERVICE_RUNNING}" -eq $? ]; then
			${SYNO_MAILPLUS_SERVERD_SCRIPT} restart
		fi
		;;

        *)
        ;;
esac
