#!/bin/sh

###############################################################
#	Usable environment variable:
#		GROUP_NAME_N, GROUP_OP_RESULT_N, NITEMS and RESULT
#
#	Note: The script should bear to be invoked multiple times
###############################################################

. /var/packages/MailPlus-Server/target/scripts/MailPlusServerCommon
MAIL_SERVER_PKG="/var/packages/MailPlus-Server"
HOOK="${MAIL_SERVER_PKG}/target/hook/AliasGroupUpdate.sh"
ACTIVE_DB_HOOK="${MAIL_SERVER_PKG}/target/hook/LicenseGroupUpdate.sh"
POLICY_HOOK="${MAIL_SERVER_PKG}/target/hook/UserGroupPolicyGroupUpdate.sh"
DELEGATION_HOOK="${MAIL_SERVER_PKG}/target/hook/DelegationGroupUpdate.sh"
DOVECOT_GROUP_CACHE_UPGRADE="${MAIL_SERVER_PKG}/target/bin/syno_gen_dovecot_group_cache"
MULTIPLE_DOMAINS_BIN="${MAIL_SERVER_PKG}/target/bin/syno_multiple_domains"

case $1 in
	--sdk-mod-ver)
		#Print SDK support version
		echo ${SDK_MOD_VER};
		;;
	--name)
		#Print package name
		echo ${MAIL_SERVER_PKG_NAME};
		;;
	--pkg-ver)
		#Print package version
		echo ${MAIL_SERVER_PKG_VERSION};
		;;
	--vendor)
		#Print package vendor
		echo ${MAIL_SERVER_PKG_VENDOR};
		;;
	--pre)
		;;
	--post)
		if ! checkAccountType; then #exit if account does not match
			exit 0
		fi
		usr_idx=1;
		usr_cnt=$((NITEMS + 1));
		while [ "$usr_idx" != "$usr_cnt" ]
		do
			eval "ORIGIN_GROUP_NAME=\$ORIGIN_GROUP_NAME_$usr_idx"
			eval "GROUP_NAME=\$GROUP_NAME_$usr_idx"
			${HOOK} --post "${ORIGIN_GROUP_NAME}" "${GROUP_NAME}" &
			${ACTIVE_DB_HOOK} --post "${ORIGIN_GROUP_NAME}" "${GROUP_NAME}" &
			usr_idx=$((usr_idx + 1));
		done
		${POLICY_HOOK} --post &
		${DELEGATION_HOOK} --post &
		${DOVECOT_GROUP_CACHE_UPGRADE} "generate" &
		${MULTIPLE_DOMAINS_BIN} "refresh" &
		;;
	*)
		echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
		;;
esac
