#!/bin/sh

###############################################################
#	This script should be hooked when invoking SYNOUserSet()
#	Usable environment variable:
#		NITEMS, ORIGIN_USER_NAME_{n}, USER_NAME_{n}, UID_{n},
#		USER_OP_RESULT_{n}, RESULT
#
#	Note: The script should bear to be invoked multiple times
###############################################################

#Include common scripts
. /var/packages/MailPlus-Server/target/scripts/MailPlusServerCommon

#At begining, acquire package settings
PackageInfoGet;

SYNO_USER_SET_ACT="user set"

MAIL_SERVER_PKG="/var/packages/MailPlus-Server"
PERSONAL_POLICY_BIN="${MAIL_SERVER_PKG}/target/bin/syno_personal_policy"
USAGE_MEMCACHED_BIN="${MAIL_SERVER_PKG}/target/bin/syno_usage_memcached"
USER_POLICY_PYTHON="${MAIL_SERVER_PKG}/target/backend_hook/scripts/userPolicySetConf.py"

UpdateUsageMemcached()
{
	if [ ! -z "$org_name" ] && [ "$org_name" != "$new_name" ]; then
		${USAGE_MEMCACHED_BIN} update_user "$org_name" "$new_name"
		if [ 0 != $? ]; then
			err_log "[Usage memcached Update]: failed to UPDATE [${org_name}]=>[${new_name}] from memcached"
		fi
	fi
}

case $1 in
	--sdk-mod-ver)
		#Print SDK support version
		echo "1.0";
		;;
	--name)
		#Print package name
		echo "${MAIL_SERVER_PKG_NAME}";
		;;
	--pkg-ver)
		#Print package version
		echo "${MAIL_SERVER_PKG_VERSION}";
		;;
	--vendor)
		#Print package vendor
		echo "${MAIL_SERVER_PKG_VENDOR}";
		;;
	--pre)
		#noop
		;;
	--post)

		#[TODO] Need refined
		${PERSONAL_POLICY_BIN} refresh
		# Update user policy config
		${USER_POLICY_PYTHON} regenPostfixPolicy
		${USER_POLICY_PYTHON} regenDovecotPolicy
		# Update memcached for usage limit
		usr_idx=1;
		usr_cnt=$(($NITEMS + 1));
		while [ "$usr_idx" != "$usr_cnt" ]
		do
			eval "org_name=\$ORIGIN_USER_NAME_$usr_idx"
			eval "new_name=\$USER_NAME_$usr_idx"
			UpdateUsageMemcached
			usr_idx=$(($usr_idx + 1));
		done
		;;
	*)
	echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
		;;
esac
