#!/bin/sh

###############################################################
#	This script should be hooked when invoking SYNOGroupSet()
#	Usable environment variable:
#		ORIGIN_GROUP_NAME, GROUP_NAME, and RESULT
#
#	Note: The script should bear to be invoked multiple times
###############################################################

#Include common scripts
. /var/packages/MailPlus-Server/target/scripts/MailPlusServerCommon

#At begining, acquire package settings
PackageInfoGet;

SYNO_GROUP_SET_ACT="group set"

MAIL_SERVER_PKG="/var/packages/MailPlus-Server"
ACTIVE_DB="${MAIL_SERVER_PKG}/etc/active_list.db"
ConfigGen="${MAIL_SERVER_PKG}/target/bin/syno_set_config"

case $1 in
	--sdk-mod-ver)
		#Print SDK support version
		echo "${SDK_MOD_VER}";
		;;
	--name)
		#Print package name
		echo "${MAIL_SERVER_PKG_NAME}";
		;;
	--pkg-ver)
		#Print package version
		echo "${MAIL_SERVER_PKG_VERSION}";
		;;
	--vendor)
		#Print package vendor
		echo "${MAIL_SERVER_PKG_VENDOR}";
		;;
	--pre)
		#noop
		;;
	--post)

		if [ ! -e $ACTIVE_DB ]; then
			exit 1;
		fi

		org_name=$2
		new_name=$3

		if [ ! -z "${org_name}" ] && [ "$org_name" != "$new_name" ]; then

			sqlite3 $ACTIVE_DB "UPDATE active_member_table SET name='$new_name' WHERE name='$org_name' and type='group';"

		fi

		if [ 0 != $? ]; then
			err_log "[LicenseGroupUpdate]: failed to UPDATE $new_name from active list db"
		fi

		$ConfigGen license
		$ConfigGen local_recipients

		;;
	*)
	echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
		;;
esac
