#!/bin/sh

. /var/packages/MailPlus-Server/target/scripts/daemon/util.sh

BASE_DIR="${MAIL_SERVER_PKG}/target"
PROG_NAME="jieba-server"
PROG_PATH="${BASE_DIR}/bin/${PROG_NAME}"
DICT_PATH="${BASE_DIR}/usr/share/CppJieba/dict/dict.txt.big"
HMM_PATH="${BASE_DIR}/usr/share/CppJieba/dict/hmm_model.utf8"
USERDICT_PATH="${BASE_DIR}/usr/share/CppJieba/dict/userdict.txt.big"
IDF_PATH="${BASE_DIR}/usr/share/CppJieba/dict/idf.txt.big"
STOP_WORDS_PATH="${BASE_DIR}/usr/share/CppJieba/dict/stop_words.txt.big"

bin_status()
{
	checkProcessRun "${PROG_NAME}"
}

conf_status()
{
	checkConfKey "jieba_enable"
	if [ "${RUNKEY_DISABLE}" -eq $? ]; then
		return "${RUNKEY_DISABLE}"
	fi
	checkConfKey "fts_enabled"
	if [ "${RUNKEY_DISABLE}" -eq $? ]; then
		return "${RUNKEY_DISABLE}"
	fi
	return "${RUNKEY_ENABLE}"
}

status()
{
	conf_status
	local jieba_enable=$?
	bin_status
	local jieba_status=$?

	if [ "${SERVICE_NOT_RUNNING}" -eq ${jieba_status} ] && [ "${RUNKEY_DISABLE}" -ne "${jieba_enable}" ]; then
		return "${SERVICE_UNKNOWN}"
	elif [ "${SERVICE_RUNNING}" -eq ${jieba_status} ] && [ "${RUNKEY_ENABLE}" -ne "${jieba_enable}" ]; then
		return "${SERVICE_UNKNOWN}"
	fi
	return ${jieba_status}
}

start() {
	echo "Starting Jieba Server ..."
	su MailPlus-Server -s /bin/sh -c "${PROG_PATH} ${DICT_PATH} ${HMM_PATH} ${USERDICT_PATH} ${IDF_PATH} ${STOP_WORDS_PATH} >/dev/null 2>&1"

	local daemon_status=""
	for i in `seq 0 1 "${MAX_TRY_TIMES}"`
	do
		status
		daemon_status=$?
		debug_log "daemon_status jieba: ${daemon_status}"
		if [ ${daemon_status} -eq "${SERVICE_RUNNING}" ]; then
			#binary is ready
			return ${START_SUCCESSFUL}
		elif [ ${daemon_status} -eq "${SERVICE_DEAD_FPID}" ]; then
			#[FIXME] Maybe we can do something to recover
			return ${START_FAILED}
		else
			sleep "${SLEEP_TIME}"
		fi
	done
	return ${START_FAILED}

}

stop() {
	killall ${PROG_NAME}
}

restart()
{
	stop
	sleep 1
	start
}

composePID()
{
	local pid=`ps -I | grep "jieba-server" | grep -v "grep" | awk -F" " 'NR == 1 {print $1}'`
	echo "${pid}"
}

composeScript()
{
	echo "/var/packages/MailPlus-Server/target/scripts/daemon/jieba.sh"
}

case "$1" in
	start)
		startOperation "mailserver_service_jieba"
		;;
	restart)
		restartOperation "mailserver_service_jieba"
		;;
	stop)
		stopOperation "mailserver_service_jieba"
		;;
	status)
		status
		;;
	*)
		echo "Usage: $0 {start|stop|restart|status}" >&2
		exit 1
		;;
esac
