#!/bin/sh

###############################################################
#	This script should be hooked when invoking user delete
#	Usable environment variable:
#		GROUP_NAME_N, GROUP_OP_RESULT_N, NITEMS and RESULT
###############################################################

. /var/packages/MailPlus-Server/target/scripts/MailPlusServerCommon

MAIL_SERVER_PKG="/var/packages/MailPlus-Server"
HOOK="${MAIL_SERVER_PKG}/target/hook/AliasGroupDelete.sh"
ACTIVE_DB_HOOK="${MAIL_SERVER_PKG}/target/hook/LicenseGroupDelete.sh"
POLICY_HOOK="${MAIL_SERVER_PKG}/target/hook/UserGroupPolicyGroupDelete.sh"
DELEGATION_HOOK="${MAIL_SERVER_PKG}/target/hook/DelegationGroupDelete.sh"
DISCLAIMER_HOOK="${MAIL_SERVER_PKG}/target/hook/DisclaimerGroupDelete.sh"
DOVECOT_GROUP_CACHE_UPGRADE="${MAIL_SERVER_PKG}/target/bin/syno_gen_dovecot_group_cache"
MULTIPLE_DOMAINS_BIN="${MAIL_SERVER_PKG}/target/bin/syno_multiple_domains"

case $1 in
	--sdk-mod-ver)
		#Print SDK support version
		echo "${SDK_MOD_VER}";
		;;
	--name)
		#Print package name
		echo "${MAIL_SERVER_PKG_NAME}";
		;;
	--pkg-ver)
		#Print package version
		echo "${MAIL_SERVER_PKG_VERSION}";
		;;
	--vendor)
		#Print package vendor
		echo "${MAIL_SERVER_PKG_VENDOR}";
		;;
	--pre)
		if ! checkAccountType; then #exit if account does not match
			exit 0
		fi
		${HOOK} --pre &
		${ACTIVE_DB_HOOK} --pre &
		${POLICY_HOOK} --pre &
		${DELEGATION_HOOK} --pre &
		${DISCLAIMER_HOOK} --pre &
		;;
	--post)
		if ! checkAccountType; then #exit if account does not match
			exit 0
		fi
		${HOOK} --post &
		${ACTIVE_DB_HOOK} --post &
		${POLICY_HOOK} --post &
		${DELEGATION_HOOK} --post &
		${DISCLAIMER_HOOK} --post &
		${DOVECOT_GROUP_CACHE_UPGRADE} "generate" &
		${MULTIPLE_DOMAINS_BIN} "refresh" &
		;;
	*)
		echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
		;;
esac
