#!/bin/sh

CreateBondHook()
{
	. /var/packages/MailPlus-Server/target/backend_hook/hookUtils.conf
	local HOST_IF=$(${MAILPLUS_SERVER_BACKEND_BINARY} --getHostIF)
	if [[ "${SLAVES}" =~ (^|,)${HOST_IF}($|,) ]]; then
		local HOST_ID=$(${MAILPLUS_SERVER_BACKEND_BINARY} --getHostID)
		if [ -z "${HOST_ID}" ]; then
			err_log "[MailPlusServerBondCreate] empty host id"
			return 1
		fi
		local NEW_IP="$(getInterfaceIP "${MASTER}")"
		if [ -z "${NEW_IP}" ]; then
			err_log "[MailPlusServerBondCreate] cant not get ip of interface [${MASTER}]"
			return 1
		fi
		## update backend config and mapping table
		if ! ${MAILPLUS_SERVER_BACKEND_BINARY} --mappingRegen "${NEW_IP}"; then
			err_log "[MailPlusServerBondCreate] - Failed to regen mailplus server id-ip mapping table"
		fi
		local KEY="node_bind_if-${HOST_ID}"
		if ! ${MAILPLUS_SERVER_BACKEND_BINARY} --setConfKeyVal "${KEY}" "${MASTER}"; then
			err_log "[MailPlusServerBondCreate] - Failed to set the new interface"
		fi
	fi
	return 0
}

DeleteBondHook()
{
	. /var/packages/MailPlus-Server/target/backend_hook/hookUtils.conf
	local HOST_IF=$(${MAILPLUS_SERVER_BACKEND_BINARY} --getHostIF)
	if [ x"${MASTER}" == x"${HOST_IF}" ]; then
		local HOST_ID=$(${MAILPLUS_SERVER_BACKEND_BINARY} --getHostID)
		if [ -z "${HOST_ID}" ]; then
			err_log "[MailPlusServerBondDelete] empty host id"
			return 1
		fi
		local NEW_IF=$(echo ${SLAVES} | cut -d "," -f1)
		local NEW_IP="$(getInterfaceIP "${NEW_IF}")"
		if [ -z "${NEW_IP}" ]; then
			err_log "[MailPlusServerBondDelete] cant not get ip of interface [${NEW_IF}]"
			return 1
		fi
		## update backend config and mapping table
		if ! ${MAILPLUS_SERVER_BACKEND_BINARY} --mappingRegen "${NEW_IP}"; then
			err_log "[MailPlusServerBondDelete] - Failed to regen mailplus server id-ip mapping table"
		fi
		local KEY="node_bind_if-${HOST_ID}"
		if ! ${MAILPLUS_SERVER_BACKEND_BINARY} --setConfKeyVal "${KEY}" "${NEW_IF}"; then
			err_log "[MailPlusServerBondDelete] - Failed to set the new interface"
		fi
	fi
	return 0
}

case $1 in
	--sdk-mod-ver)
	#Print SDK support version
	echo "1.0";
	;;
	--name)
	#Print package name
	echo "MailPlus-Server";
	;;
	--pkg-ver)
	#Print package version
	echo "1.0";
	;;
	--vendor)
	#Print package vendor
	echo "Synology";
	;;
	--pre)
	;;
	--post)
		if [ x"${ACTION}" == x"create" ]; then
			CreateBondHook
		elif [ x"${ACTION}" == x"delete" ]; then
			DeleteBondHook
		fi
	;;
	*)
	echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
	;;
esac
