#!/bin/sh

###############################################################
#   This script should be hooked when invoking user delete
#   Usable environment variable:
#       NITEMS, USER_NAME_X, USER_OP_RESULT_X, RESULT
###############################################################

#Include common scripts
. /var/packages/MailPlus-Server/target/scripts/MailPlusServerCommon

#At begining, acquire package settings
PackageInfoGet;

MAIL_SERVER_PKG="/var/packages/MailPlus-Server"
ACTIVE_DB="${MAIL_SERVER_PKG}/etc/active_list.db"
ConfigGen="${MAIL_SERVER_PKG}/target/bin/syno_set_config"

case $1 in
	--sdk-mod-ver)
		#Print SDK support version
		echo "${SDK_MOD_VER}";
		;;
	--name)
		#Print package name
		echo "${MAIL_SERVER_PKG_NAME}";
		;;
	--pkg-ver)
		#Print package version
		echo "${MAIL_SERVER_PKG_VERSION}";
		;;
	--vendor)
		#Print package vendor
		echo "${MAIL_SERVER_PKG_VENDOR}";
		;;
	--pre)
		#noop
		;;
	--post)

		if [ ! -e $ACTIVE_DB ]; then
			exit 1;
		fi

		usr_idx=1;
		usr_cnt=$(($NITEMS + 1));
		while [ "$usr_idx" != "$usr_cnt" ]
		do
			eval "usr_name=\$USER_NAME_$usr_idx"

			if [ ! -z "$usr_name" ]; then

				sqlite3 $ACTIVE_DB "DELETE FROM active_member_table WHERE name='$usr_name' and type='user';"

				if [ 0 != $? ]; then
					err_log "[LicenseUserDelete]: failed to delete $usr_name from active list db"
				fi
			fi

			usr_idx=$(($usr_idx + 1));
		done
		$ConfigGen license
		$ConfigGen local_recipients
		;;
	*)
	echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
		;;
esac
