#!/bin/sh

###############################################################
#	This script should be hooked when invoking SYNOGroupDelete()
#	Usable environment variable:
#		GROUP_NAME_N, GROUP_OP_RESULT_N, NITEMS and RESULT
###############################################################

#Include common scripts
. /var/packages/MailPlus-Server/target/scripts/MailPlusServerCommon
. /var/packages/MailPlus-Server/target/backend_hook/hookUtils.conf

#At begining, acquire package settings
PackageInfoGet;
MAIL_SERVER_PKG="/var/packages/MailPlus-Server"
ALIAS_DB="${MAIL_SERVER_PKG}/etc/alias.db"
ConfigGen="${MAIL_SERVER_PKG}/target/bin/syno_set_config"

case $1 in
	--sdk-mod-ver)
		#Print SDK support version
		echo "${SDK_MOD_VER}";
		;;
	--name)
		#Print package name
		echo "${MAIL_SERVER_PKG_NAME}";
		;;
	--pkg-ver)
		#Print package version
		echo "${MAIL_SERVER_PKG_VERSION}";
		;;
	--vendor)
		#Print package vendor
		echo "${MAIL_SERVER_PKG_VENDOR}";
		;;
	--pre)
		#noop
		;;
	--post)

	if [ ! -e $ALIAS_DB ]; then
		exit 1;
	fi

	group_idx=1;
	group_cnt=$(($NITEMS + 1));
	(
	if flock -w 30 -x 100; then
		chown MailPlus-Server:MailPlus-Server ${ALIAS_DB_FILE_LOCK}
		chmod 644 ${ALIAS_DB_FILE_LOCK}

		while [ "$group_idx" != "$group_cnt" ]
		do
			eval "group_name=\$GROUP_NAME_$group_idx"
			if [ ! -z "$group_name" ]; then
				sqlite3 $ALIAS_DB "DELETE FROM alias_info_table WHERE member='$group_name' and type=1;"
				if [ 0 != $? ]; then
					err_log "[Alias Group Delete]: failed to delete $group_name from alias db"
				fi
			fi

			group_idx=$(($group_idx + 1));
		done

		flock -u 100
		rm ${ALIAS_DB_FILE_LOCK}
	else
		err_log "[Alias Group Delete]: failed to get lock [${ALIAS_DB_FILE_LOCK}]"
	fi
	)100> ${ALIAS_DB_FILE_LOCK}
	$ConfigGen virtual_alias
		;;
	*)
	echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
		;;
esac
