#!/bin/sh
. /var/packages/MailPlus-Server/target/backend_hook/hookUtils.conf
loadEnv
CONF_SRC_FOLDER="/var/packages/MailPlus-Server/target/etc/"
SCHEDULE_CONF_DEST_FOLDER="/usr/syno/etc/synocron.d/"
ROTATE_CONF_DEST_FOLDER="/usr/local/etc/logrotate.d/"
ROTATE_SIZE=`${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal rotate_size`; : ${ROTATE_SIZE:="30"}
ROTATE_ENABLE_PERIOD="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "rotate_enable_period")"
ROTATE_PERIOD="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "rotate_period")"
AGGR_LOG_CONF="${ROTATE_CONF_DEST_FOLDER}/mailplus_server_aggr_maillog.conf"
FORWARD_LOG_CONF="${ROTATE_CONF_DEST_FOLDER}/mailplus_server_forward_log.conf"
FORWARD_DEST=""
ROTATE_CONF="\n\
__LOG_FILE_LOCATION__\n\
{\n\
	rotate 10\n\
	dateext\n\
	dateformat -%Y%m%d-%s\n
	compress\n\
	compresscmd /usr/bin/xz\n\
	compressext .xz\n\
	compressoptions -3\n\
	notifempty\n\
	maxsize __ROTATE_SIZE__\n\
	__ROTATE_PERIOD__\n\
	missingok\n\
	postrotate\n\
	/usr/syno/sbin/synoservice --reload syslog-ng || true\n\
	endscript\n\
}"

replace_keywords()
{
	local CONF_FILE=$1
	local LOG_FILE=$2
	sed -i "s=__LOG_FILE_LOCATION__=${LOG_FILE}=g" "${CONF_FILE}"
	sed -i "s/__ROTATE_SIZE__/${ROTATE_SIZE}M/g" "${CONF_FILE}"
	if [ "yes" == "${ROTATE_ENABLE_PERIOD}" -a ! -z "ROTATE_PERIOD" ]; then
		sed -i "s/__ROTATE_PERIOD__/${ROTATE_PERIOD}/g" "${CONF_FILE}"
	else
		sed -i "s/__ROTATE_PERIOD__//g" "${CONF_FILE}"
	fi

}

gen_aggr_mail_log_rotate_conf()
{
	local AGGR_MAIL_LOG_FILE="${PRIVATE_LOCATION}/var/aggr_log/aggr_maillog"

	echo -e "${ROTATE_CONF}" > ${AGGR_LOG_CONF}
	replace_keywords "${AGGR_LOG_CONF}" "${AGGR_MAIL_LOG_FILE}"
	chown root:root ${AGGR_LOG_CONF}
	chmod 644  ${AGGR_LOG_CONF}
}

gen_forward_log_rotate_conf()
{
	local FORWARD_OTHER_NODE="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "forward_to_other_node")"
	local NODE_IP="$(getHostIP)"
	local FORWARD_DEST="$(getNonBalancerNodeIP)"
	local FORWARD_MAILLOG_CONF="${PRIVATE_LOCATION}/var/aggr_log/forwarded/aggr_maillog"
	local FORWARD_MAIL_LOG_CONF="${PRIVATE_LOCATION}/var/aggr_log/forwarded/aggr_mail_log"
	local FORWARD_SECURITY_LOG_CONF="${PRIVATE_LOCATION}/var/aggr_log/forwarded/aggr_security_log"

	if [ "${NODE_IP}" != "${FORWARD_DEST}" -o "yes" != "${FORWARD_OTHER_NODE}" -o -z "${FORWARD_DEST}" ] || isLoadBalancer; then
		return
	fi

	echo -e "${ROTATE_CONF}" > ${FORWARD_LOG_CONF}
	replace_keywords "${FORWARD_LOG_CONF}" "${FORWARD_MAILLOG_CONF}"

	echo -e "${ROTATE_CONF}" >> ${FORWARD_LOG_CONF}
	replace_keywords "${FORWARD_LOG_CONF}" "${FORWARD_MAIL_LOG_CONF}"

	echo -e "${ROTATE_CONF}" >> ${FORWARD_LOG_CONF}
	replace_keywords "${FORWARD_LOG_CONF}" "${FORWARD_SECURITY_LOG_CONF}"
	chown root:root ${FORWARD_LOG_CONF}
	chmod 644 ${FORWARD_LOG_CONF}
}

#rotate schedule for database
if isKeyChanged "balancer_master_node"; then
	/usr/bin/rm -f "${SCHEDULE_CONF_DEST_FOLDER}mailserver_rotate_schedule.conf"
	if isLoadBalancer; then
		ln -s "${CONF_SRC_FOLDER}mailserver_rotate_schedule.conf" ${SCHEDULE_CONF_DEST_FOLDER}
	fi
	/sbin/reload synocrond
fi

#rotate config for aggr_maillog
if isKeyChanged "balancer_master_node" || isKeyChanged "rotate_size" || isKeyChanged "rotate_period" || isKeyChanged "rotate_enable_period" || isKeyChanged "forward_to_other_node"; then
	/usr/bin/rm -f ${AGGR_LOG_CONF}
	/usr/bin/rm -f ${FORWARD_LOG_CONF}
	if isLoadBalancer; then
		gen_aggr_mail_log_rotate_conf
	else
		gen_forward_log_rotate_conf
	fi
fi
exit 0
