#!/bin/sh

. /var/packages/MailPlus-Server/target/backend_hook/hookUtils.conf
loadEnv

## Check identity
NODE_ID=$(getHostID)
DIRECTOR_NODE=$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "balancer")
if ! containString "${NODE_ID}" "${DIRECTOR_NODE}"; then
	${CALLBACK_BINARY} "director" "stop"
	exit 0
fi

balancerAddress="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "balancer_address")"
mailServers="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getAliveServ "mailserver_service_dovecot")"
if [ "" == "${balancerAddress}" -o "" == "${mailServers}" ];then
	exit 0
fi

DirectorRefresh()
{
	local enable_balancer_address="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "enable_balancer_address")"
	if [ "${enable_balancer_address}" == "no" ]; then
		${CALLBACK_BINARY} "director" "stop"
		return 0
	fi

	if isLoadBalancer; then
		local imapPort="$(imapPop3PortGet "imap")"
		local imapsPort="$(imapPop3PortGet "imaps")"
		local pop3Port="$(imapPop3PortGet "pop3")"
		local pop3sPort="$(imapPop3PortGet "pop3s")"
		local doveadmPort="24245"
		local enableDsyncSSL=$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "dsync_ssl_enable")
		local directorImapPort="${imapPort}"
		local directorImapSSL=""
		local directorImapStarttls="starttls=any-cert"
		local directorPop3Port="${pop3Port}"
		local directorPop3SSL=""
		local directorPop3Starttls="starttls=any-cert"

		local imapEnable="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "imap_enabled")"
		if [ "yes" != "${imapEnable}" ]; then
			imapPort="0"
		fi

		## Close director if all port == 0
		if [ 0 -eq "${imapPort}" ] && [ 0 -eq "${imapsPort}" ] && [ 0 -eq "${pop3Port}" ] && [ 0 -eq "${pop3sPort}" ]; then
			${CALLBACK_BINARY} "director" "stop"
			return 0
		fi

		## Change config
		cp -f "/${CONF_TEMPLATE_DIR}/10-master-director.template" "/var/packages/${PACKAGE_NAME}/target/etc/director/conf.d/10-master.conf"
		sed -i -e "s|__DIRECTOR_IP__|${balancerAddress}|g" \
		    -i -e "s|__IMAP_PORT__|${imapPort}|g" \
		    -i -e "s|__IMAPS_PORT__|${imapsPort}|g" \
		    -i -e "s|__POP3_PORT__|${pop3Port}|g" \
		    -i -e "s|__POP3S_PORT__|${pop3sPort}|g" \
		    -i -e "s|__DOVEADM_PORT__|${doveadmPort}|g" \
		    -i -e "s|__PRIVATE_IP__|${doveadmPort}|g" "/var/packages/${PACKAGE_NAME}/target/etc/director/conf.d/10-master.conf"
		
		cp -f "/${CONF_TEMPLATE_DIR}/20-director-imap.template" "/var/packages/${PACKAGE_NAME}/target/etc/director/conf.d/20-imap.conf"
		if [ ${imapPort} -eq 0 ]; then
			directorImapPort="${imapsPort}"
			directorImapSSL="ssl=any-cert"
			directorImapStarttls=""
		fi
		sed -i -e "s|__IMAP_PORT__|${directorImapPort}|g" \
		    -i -e "s|__IMAP_SSL__|${directorImapSSL}|g" \
		    -i -e "s|__IMAP_STARTTLS__|${directorImapStarttls}|g" "/var/packages/${PACKAGE_NAME}/target/etc/director/conf.d/20-imap.conf"
		
		cp -f "/${CONF_TEMPLATE_DIR}/20-director-pop3.template" "/var/packages/${PACKAGE_NAME}/target/etc/director/conf.d/20-pop3.conf"
		if [ "${pop3Port}" -eq 0 ]; then
			directorPop3Port="${pop3sPort}"
			directorPop3SSL="ssl=any-cert"
			directorPop3Starttls=""
		fi
		sed -i -e "s|__POP3_PORT__|${directorPop3Port}|g" \
		    -i -e "s|__POP3_SSL__|${directorPop3SSL}|g" \
		    -i -e "s|__POP3_STARTTLS__|${directorPop3Starttls}|g" "/var/packages/${PACKAGE_NAME}/target/etc/director/conf.d/20-pop3.conf"

		if [ "${enableDsyncSSL}" != "no" ]; then
			GenerateInternalCaChain
			sed -i -e "s|__ENABLE_DSYNC_SSL__|yes|g" "/var/packages/${PACKAGE_NAME}/target/etc/director/conf.d/10-master.conf"
		else
			sed -i -e "s|__ENABLE_DSYNC_SSL__|no|g" "/var/packages/${PACKAGE_NAME}/target/etc/director/conf.d/10-master.conf"
		fi

		cp "/${CONF_TEMPLATE_DIR}/10-director.template" "/var/packages/${PACKAGE_NAME}/target/etc/director/conf.d/10-director.conf"
		sed -i -e "s|__DIRECTOR_SERVER__|${balancerAddress}|g" "/var/packages/${PACKAGE_NAME}/target/etc/director/conf.d/10-director.conf" \
		    -i -e "s|__MAIL_SERVER__|${mailServers}|g" "/var/packages/${PACKAGE_NAME}/target/etc/director/conf.d/10-director.conf"

		${CALLBACK_BINARY} "director" "restart"

	else
		${CALLBACK_BINARY} "director" "stop"
	fi

	return 0
}

DirectorRefresh
