#!/bin/sh

. /var/packages/MailPlus-Server/target/backend_hook/hookUtils.conf
loadEnv

USER_DATA_COLLECTOR_SRC="/var/packages/MailPlus-Server/target/scripts/user_data_collector/mailplus_server.config"
USER_DATA_COLLECTOR_DEST="/usr/syno/etc/user.data.conf/MailPlus-Server-mailplus_server.config"

## Check identity
nodeID=$(getHostID)
BALANCER_NODE=$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "balancer")
if ! containString "${nodeID}" "${BALANCER_NODE}"; then
	exit 0
fi

setMasterInterface


if isLoadBalancer; then
	"${PRIVATE_LOCATION}/bin/syno_license_tool" refresh_limit
	if [ 0 -eq $? ]; then
		err_log "refresh_limit success."
	else
		err_log "refresh_limit failed."
	fi
	install --mode 644 --owner root --group root ${USER_DATA_COLLECTOR_SRC} ${USER_DATA_COLLECTOR_DEST}
else
	[ -e ${USER_DATA_COLLECTOR_DEST} ] && /bin/rm ${USER_DATA_COLLECTOR_DEST}
fi

exit 0
