#!/bin/sh

. /var/packages/MailPlus-Server/target/backend_hook/hookUtils.conf
loadEnv

## Check identity
NODE_ID=$(getHostID)
storage_servers="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "storager")"

LOCAL_DOMAIN_NAME="@local"

if ! containString "${NODE_ID}" "${storage_servers}"; then
	exit 0
fi

VOLUME_CONFIG_KEY="general_storage_volume-${NODE_ID}"
STORAGE_VOLUME="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "${VOLUME_CONFIG_KEY}")"

if [ "${STORAGE_VOLUME}" == "" ]; then
	err_log "There are no storage volume"
	exit 0
fi

createMailDir()
{
	## Get current domain
	local accountType="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "account_type")"
	local domainName=""

	if [ "${accountType}" == "win" ]; then
		domainName="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "win_domain_short_name")"
	elif [ "${accountType}" == "ldap" ]; then
		domainName="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "acc_domain_name")"
	else
		domainName="${LOCAL_DOMAIN_NAME}"
	fi

	if [ "${domainName}" == "" ]; then
		err_log "It cannot get domain"
		return 1
	fi

	if [ ! -d "/${STORAGE_VOLUME}/${MAIL_SHARE_NAME}/${domainName}" ]; then
		mkdir "/${STORAGE_VOLUME}/${MAIL_SHARE_NAME}/${domainName}"
	fi

	local sharedMailboxDBDir="/${STORAGE_VOLUME}/${MAIL_SHARE_NAME}/${domainName}/db"
	if [ ! -d "${sharedMailboxDBDir}" ]; then
		mkdir "${sharedMailboxDBDir}"
		/usr/syno/bin/synoacltool -add "${sharedMailboxDBDir}" "everyone:*:allow:rwxpdD-------:---n"
	fi
	return 0
}

exportNFS()
{
	## Check NFS has enabled
	"/var/packages/${PACKAGE_NAME}/target/backend_hook/scripts/setNFS.py"
	if [ 0 -ne $? ]; then
		return 1
	fi

	## Check share has exported
	local exportPath="/${STORAGE_VOLUME}/${MAIL_SHARE_NAME}/"
	local NFS_RULE="${exportPath}     *(rw,async,no_wdelay,crossmnt,no_root_squash,insecure_locks,sec=sys,anonuid=1025,anongid=100)"
	/usr/bin/sed -i -e "s|${exportPath}|__REMOVE_SYMBOL__|" /etc/exports
	/usr/bin/sed -i -e "/__REMOVE_SYMBOL__/d" /etc/exports
	/usr/bin/sed -i -e "s|${exportPath}|__REMOVE_SYMBOL__|" /etc/exports_syno
	/usr/bin/sed -i -e "/__REMOVE_SYMBOL__/d" /etc/exports_syno
	/usr/bin/echo "${NFS_RULE}" >> /etc/exports
	/usr/bin/echo "${NFS_RULE}" >> /etc/exports_syno
	/usr/sbin/exportfs -ar

	return 0
}
relinkVolume()
{
	if [ -L "${MAIL_STORAGE_DIR_PATH}" ]; then
		/usr/bin/rm -fr "${MAIL_STORAGE_DIR_PATH}"
	elif [ -d "${MAIL_STORAGE_DIR_PATH}" ]; then
		/usr/bin/mv "${MAIL_STORAGE_DIR_PATH}" "${MAIL_STORAGE_DIR_PATH_BAK}"
	fi

	/usr/bin/ln -s "/${STORAGE_VOLUME}/${MAIL_SHARE_NAME}" "${MAIL_STORAGE_DIR_PATH}"

	## Comment NFS support
	#exportNFS
	#if [ 0 -ne $? ]; then
	#	err_log "Failed to export NFS"
	#	return 1
	#fi

	return 0
}

## Create share if it not exist
PrepareMailPlusShareEnv "${STORAGE_VOLUME}"

if isKeyChanged "${VOLUME_CONFIG_KEY}"; then
	if ! relinkVolume; then
		err_log "Failed to relinkVolume"
		exit 1
	fi
fi

if isKeyChanged "acc_domain_name" || isKeyChanged "account_type" || isKeyChanged "${VOLUME_CONFIG_KEY}"; then
	if ! createMailDir; then
		err_log "Failed to createMailDir"
		exit 1
	fi
fi

exit 0
