#!/usr/bin/python
import sys
from multiprocessing import Pool

sys.path.append("/var/packages/MailPlus-Server/target/backend_hook/")
from _Utils import *
from _Define import *

'''
    Due to some registerd service would not have script to start up
    So we still need to have 40-roleChange.py
'''

MAILER_SERV=""
STORAGER_SERV="mailserver_service_storage_backend"
BALANCER_SERV="mailserver_service_haproxy mailserver_service_director mailserver_service_balancer"

ROLE_MAILER_KEY="mailer"
ROLE_STORAGER_KEY="storager"
ROLE_BALANCER_KEY="balancer"

def getServList(role):
    if role == ROLE_MAILER_KEY:
        return MAILER_SERV.split(' ')
    elif role == ROLE_STORAGER_KEY:
        return STORAGER_SERV.split(' ')
    elif role == ROLE_BALANCER_KEY:
        return BALANCER_SERV.split(' ')
def registerOrDeregisterServ(servObj):
    import time
    backendAPI = BackendAPI()
    retry = 0

    serv = servObj["serv"]
    isRegister = servObj["isRegister"]

    while retry < REGISTER_SERV_RETRY_MAX_TIMES:
        if isRegister:
            _, ret = backendAPI.registerServ(serv)
        else:
            _, ret = backendAPI.deRegisterServ(serv)

        if not ret:
            SYSLOG(LOG_ERR, "Failed to De/Register serv %s, isRegister %d" % (serv, isRegister))
            time.sleep(1)
        else:
            break
        retry += 1

    servObj["ret"] = retry < REGISTER_SERV_RETRY_MAX_TIMES
def setup(role, hostID):
    backendAPI = BackendAPI()
    roleNode = backendAPI.mailconfGet(role)
    servList = getServList(role)
    pool = Pool(10)

    registServ = False
    for _ in roleNode.split(' '):
        if _ == hostID:
            registServ = True
            break

    servObjList = []
    for serv in servList:
        if not serv:
            continue
        servObj = {
            "serv": serv,
            "ret": True,
            "isRegister": registServ
        }
        servObjList.append(servObj)
    pool.map(registerOrDeregisterServ, servObjList)
    for _ in servObjList:
        if not _["ret"]:
            return False
    return True
def main():
    import os
    retCode = 0

    hostID = getHostID()

    if isKeyChange(ROLE_MAILER_KEY):
        if not setup(ROLE_MAILER_KEY, hostID):
           retCode = 1

    if isKeyChange(ROLE_STORAGER_KEY):
        if not setup(ROLE_STORAGER_KEY, hostID):
            retCode = 1

    if isKeyChange(ROLE_BALANCER_KEY):
        if not setup(ROLE_BALANCER_KEY, hostID):
            retCode = 1

    exit(retCode)
if __name__ == '__main__':
    try:
        main()
    except Exception as e:
        SYSLOG(LOG_ERR, "exception: %s" % (e))
