# <@LICENSE>
# Copyright 2004 Apache Software Foundation
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
#     http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# </@LICENSE>

=head1 NAME

Mail::SpamAssassin::Plugin::Tokenizer - Tokenizer plugin base class

=head1 SYNOPSIS

=head2 SpamAssassin configuration:

  loadplugin MyTokenizerPlugin /path/to/MyTokenizerPlugin.pm

=head2 Perl code:

  use Mail::SpamAssassin::Plugin::Tokenizer;
  use vars qw(@ISA);
  @ISA = qw(Mail::SpamAssassin::Plugin::Tokenizer);
  # language to use this plugin
  our $language = 'ja';

  # constructor: register language
  sub new {
    my $class = shift;
    my $mailsaobject = shift;

    # some boilerplate...
    $class = ref($class) || $class;
    my $self = $class->SUPER::new($mailsaobject, $language);
    bless ($self, $class);

    return $self;
  }

  # tokenize function
  sub tokenize {
    my $self = shift;
    my $text_array_ref = shift;

    ......

    return $tokenized_array_ref;
  }


=head1 DESCRIPTION

This plugin is the base class of tokenizer plugin.
You must define tokenize() and $language

=head1 INTERFACE

  sub tokenize {
    my $self = shift;
    my $text_array_ref = shift;

    ......
 
    return $tokenized_array_ref;
  }

=cut

package Mail::SpamAssassin::Plugin::Tokenizer;

use Mail::SpamAssassin::Plugin;
use Mail::SpamAssassin::Logger;
use strict;
use warnings;
use bytes;

use vars qw(@ISA);
@ISA = qw(Mail::SpamAssassin::Plugin);

sub new {
  my $class = shift;
  my $mailsaobject = shift;
  my $language = shift;

  # some boilerplate...
  $class = ref($class) || $class;
  my $self = $class->SUPER::new($mailsaobject);
  bless ($self, $class);

  if ($language) {
    $self->{main}->{conf}->{tokenizer}->{$language} = $self;
  }
  else {
    dbg("plugin: $self: \$language is not defined");
  }

  return $self;
}

sub tokenize {
  my ($self, $ref) = @_;

  return $ref;
}

1;

