#!/bin/sh

. /var/packages/MailPlus-Server/target/scripts/daemon/util.sh

MAIL_DAEMON_PID="/var/run/mailplus_server/syno_mailserverd.pid"

bin_status()
{
	#check syno_mailserverd
	checkPidFileStatus "syno_mailserverd" "${MAIL_DAEMON_PID}"
}

status()
{
	bin_status
	local mailserverd_status=$?

	return ${mailserverd_status}
}

start()
{
	echo "Starting Mail Daemon..."
	initctl start pkg-MailPlus-Server_mailserverd

	local daemon_status=""
	for i in `seq 0 1 "${MAX_TRY_TIMES}"`
	do
		status
		daemon_status=$?
		debug_log "daemon_status syno_mailserverd: ${daemon_status}"
		if [ ${daemon_status} -eq "${SERVICE_RUNNING}" ]; then
			#binary is ready
			return ${START_SUCCESSFUL}
		elif [ ${daemon_status} -eq "${SERVICE_DEAD_FPID}" ]; then
			#[FIXME] Maybe we can do something to recover
			return ${START_FAILED}
		else
			sleep "${SLEEP_TIME}"
		fi
	done
	return ${START_FAILED}
}

stop()
{
    echo "Stop Mail Daemon..."
	initctl stop pkg-MailPlus-Server_mailserverd
}

restart()
{
	stop
	sleep 1
	start
}

composePID()
{
	local pid=$(cat ${MAIL_DAEMON_PID} | sed -e 's/^[[:space:]]*//' -e 's/[[:space:]]*$//')
	echo "${pid}"
}

composeScript()
{
	echo "/var/packages/MailPlus-Server/target/scripts/daemon/syno_mailserverd.sh"
}


case "$1" in
	start)
		startOperation "mailserver_service_syno_mailserverd"
		;;
	restart)
		restartOperation "mailserver_service_syno_mailserverd"
		;;
	pid)
		composePID
		;;
	stop)
		stopOperation "mailserver_service_syno_mailserverd"
		;;
	status)
		status
		;;
	*)
		echo "Usage: $0 {start|stop|restart|status|pid}" >&2
		exit 1
		;;
esac
