#!/bin/sh

. /var/packages/MailPlus-Server/target/backend_hook/hookUtils.conf
. /var/packages/MailPlus-Server/target/scripts/daemon/util.sh

ANTI_VIRUS_ENGINE="clamav"
ANTI_VIRUS_BIN="${MAIL_SERVER_PKG}/target/bin/syno_anti-virus"
ANTI_VIRUS_PID="/var/run/mailplus_server/syno_anti-virus.pid"
CLAMD_PID="/var/run/mailplus_server/clamd.pid"
SECURITY_CHECK="${MAIL_SERVER_PKG}/target/scripts/SecurityCheck.sh"

bin_status()
{
	checkPidFileStatus "syno_anti-virus" "${ANTI_VIRUS_PID}"
	local anti_virus_status=$?
	if [ "${SERVICE_RUNNING}" != ${anti_virus_status} ] && [ "${SERVICE_NOT_RUNNING}" != ${anti_virus_status} ] ; then
		return ${anti_virus_status}
	fi

	checkProcessRun "freshclam"
	local fresh_clam_status=$?
	if [ "${SERVICE_RUNNING}" != ${fresh_clam_status} ] && [ "${SERVICE_NOT_RUNNING}" != ${fresh_clam_status} ] ; then
		return ${fresh_clam_status}
	fi

	checkPidFileStatus "clamd" "${CLAMD_PID}"
	local clamd_status=$?
	if [ "${SERVICE_RUNNING}" != ${clamd_status} ] && [ "${SERVICE_NOT_RUNNING}" != ${clamd_status} ] ; then
		return ${clamd_status}
	fi

	if [ "${SERVICE_RUNNING}" == ${fresh_clam_status} ] ; then
		return "${SERVICE_UPDATING}"
	fi

	if [ "${SERVICE_RUNNING}" == ${anti_virus_status} ] ; then
		return "${SERVICE_STARTING}"
	fi

	if [ "${SERVICE_RUNNING}" == ${clamd_status} ] ; then
		return "${SERVICE_RUNNING}"
	fi

	if [ "${SERVICE_NOT_RUNNING}" == ${clamd_status} ] && [ "${SERVICE_NOT_RUNNING}" == ${anti_virus_status} ] && [ "${SERVICE_NOT_RUNNING}" == ${fresh_clam_status} ]; then
		return "${SERVICE_NOT_RUNNING}"
	fi

	return "${SERVICE_UNKNOWN}"
}

conf_status()
{
	checkConfKey "anti_virus_enable"
	local anti_virus_enable=$?
	local anti_virus_engine="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "anti_virus_engine")"

	if [ "${RUNKEY_ENABLE}" == ${anti_virus_enable} ] && [ "${ANTI_VIRUS_ENGINE}" == ${anti_virus_engine} ] ; then
		return "${RUNKEY_ENABLE}"
	else
		return "${RUNKEY_DISABLE}"
	fi
}

status()
{
	conf_status
	local clamav_enable=$?
	bin_status
	local clamav_status=$?

	if [ "${SERVICE_NOT_RUNNING}" -eq ${clamav_status} ] && [ "${RUNKEY_DISABLE}" -ne "${clamav_enable}" ]; then
		return "${SERVICE_UNKNOWN}"
	elif [ "${SERVICE_STARTING}" -eq ${clamav_status} ] && [ "${RUNKEY_ENABLE}" -ne "${clamav_enable}" ]; then
		return "${SERVICE_UNKNOWN}"
	elif [ "${SERVICE_RUNNING}" -eq ${clamav_status} ] && [ "${RUNKEY_ENABLE}" -ne "${clamav_enable}" ]; then
		return "${SERVICE_UNKNOWN}"
	fi

	return ${clamav_status}
}

start()
{
	${ANTI_VIRUS_BIN} start

	local daemon_status=""
	for i in `seq 0 1 "${MAX_TRY_TIMES}"`
	do
		status
		daemon_status=$?
		debug_log "daemon_status clamav: ${daemon_status}"
		if [ ${daemon_status} -eq "${SERVICE_RUNNING}" ] || [ ${daemon_status} -eq "${SERVICE_UPDATING}" ] || [ ${daemon_status} -eq "${SERVICE_STARTING}" ]; then
			#binary is ready
			err_log "ClamAV is started"
			return ${START_SUCCESSFUL}
		elif [ ${daemon_status} -eq "${SERVICE_DEAD_FPID}" ]; then
			#[FIXME] Maybe we can do something to recover
			return ${START_FAILED}
		else
			sleep "${SLEEP_TIME}"
		fi
	done
	return ${START_FAILED}
}

stop()
{
	${ANTI_VIRUS_BIN} stop
	err_log "ClamAV is stopped"
}

restart()
{
	stop
	sleep 1
	start
}


composePID()
{
	#it is very different becuase it will do updating/starting/start
	local pid=""
	if [ -f "${ANTI_VIRUS_PID}" ]; then
		pid=$(cat "${ANTI_VIRUS_PID}" | sed -e 's/^[[:space:]]*//' -e 's/[[:space:]]*$//')
		echo "${pid}"
		return
	fi

	pid=`ps -I | grep "freshclam" | grep -v "grep" | awk -F" " 'NR == 1 {print $1}'`
	if [ x"" != x"${pid}" ]; then
		echo "${pid}"
		return
	fi

	if [ -f "${CLAMD_PID}" ]; then
		pid=$(cat ${CLAMD_PID} | sed -e 's/^[[:space:]]*//' -e 's/[[:space:]]*$//')
		echo "${pid}"
		return
	fi
	err_log "Not found any for clamav"
	echo ""
}

composeScript()
{
	echo "/var/packages/MailPlus-Server/target/scripts/daemon/clamav.sh"
}

update()
{
	if isLoadBalancer; then
		nowTime=$(date "+%Y/%m/%d %H:%M:%S")
		${MAILPLUS_SERVER_BACKEND_BINARY} --setConfKeyVal "anti_virus_last_update_time" "${nowTime}"
	fi
}

update_local_only()
{
	${ANTI_VIRUS_BIN} update

	# update anti-spam status for dashboard
	${SECURITY_CHECK} "anti_virus"
}

reload()
{
	${ANTI_VIRUS_BIN} reload
}

case "$1" in
	start)
		startOperation "mailserver_service_clamav"
		;;
	restart)
		restartOperation "mailserver_service_clamav"
		;;
	stop)
		stopOperation "mailserver_service_clamav"
		;;
	status)
		status
		;;
	update)
		update
		;;
	update_local_only)
		update_local_only
		;;
	reload)
		reload
		;;
	*)
		echo "Usage: $0 {start|stop|restart|status|update|reload|update_local_only}" >&2
		exit 1
		;;
esac
