#!/usr/bin/perl

use strict;
use warnings;

use lib '/var/packages/MailPlus-Server/target/share/perl5/vendor_perl';
use lib '/var/packages/MailPlus-Server/target/lib/perl5/vendor_perl';
use lib '/var/packages/MailPlus-Server/target/lib/MIMEDefang';

use File::Temp qw(tempdir);
use MIME::Parser;

use MailPlusServer::Util;

my $TempDirTemplate   = '/var/packages/MailPlus-Server/target/var/mime_parser_XXXXXX';

sub main {
	my $parser = new MIME::Parser;
	my $tempdir = tempdir($TempDirTemplate, CLEANUP => 1);
	$parser->output_dir($tempdir);

	my $fh;
	my $entity = $parser->parse(\*STDIN);
	my $head = $entity->head;
	my $mail = '';

	my $sender = $head->get($MailPlusServer::Util::HeaderSender);
	my $recipients = $head->get($MailPlusServer::Util::HeaderRecipients);

	foreach my $header (@MailPlusServer::Util::QuarantineTmpHeaders) {
		$entity->head->delete($header);
	}
	$entity->head->add($MailPlusServer::Util::HeaderRelease, 'yes');

	$mail = MailPlusServer::Util::entity_print($entity);
	MailPlusServer::Util::send_mail($sender, $recipients, $mail);
}

main();
