#!/bin/sh

. /var/packages/MailPlus-Server/target/backend_hook/hookUtils.conf
loadEnv
CONF_SRC_FOLDER="${PRIVATE_LOCATION}/etc/"
CON_DEST_FOLDER="/usr/local/etc/syslog-ng/patterndb.d/"
SYSLOG_NG_CA_DIR="/var/packages/${PACKAGE_NAME}/etc/syslog_ca"
ROLE_BALANCER_MASTER="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getMasterBalancer)"
LOG_DAEMON_SCRIPT="${PRIVATE_LOCATION}/scripts/daemon/syno_mailloggerd.sh"
SO_RCVBUF_SIZE="4194304"
FORWARD_DEST=""
FORWARD_CLIENT_CONF_ORIG="\\
	network(\n\
		\"FORWARD_DEST_IP\"\n\
		port(9526)\n\
		transport(tcp)\n\
		ip-protocol(4)\n\
		flush-lines(200)\n\
		flush-timeout(10000)\n\
		suppress(0)\n\
	);\n"
FORWARD_CLIENT_CONF_MAILLOG="\\
	network(\n\
		\"FORWARD_DEST_IP\"\n\
		port(9527)\n\
		transport(tcp)\n\
		ip-protocol(4)\n\
		template(\"\$(format-json --key MESSID --key QUEID --key SENDER --key RECEIVER HOST=\${HOST} TIMESTAMP=int64(\${TIMESTAMP}) SIZE=int64(\${SIZE}) STATUS=int(\${STATUS}) --key SUBJECT --key ORIMAILTO)\\\n\")\n\
		flush-lines(200)\n\
		flush-timeout(10000)\n\
		suppress(0)\n\
	);\n"
FORWARD_CLIENT_CONF_SECURITYLOG="\\
	network(\n\
		\"FORWARD_DEST_IP\"\n\
		port(9528)\n\
		transport(tcp)\n\
		ip-protocol(4)\n\
		template(\"\$(format-json --key type --key event --key from HOST=\${HOST} TIMESTAMP=int64(\${UNIXTIME}) -- key subject)\\\n\")\n\
		flush-lines(200)\n\
		flush-timeout(10000)\n\
		suppress(0)\n\
	);\n"
FORWARD_SERVER_CONF_ORIG_SOURCE="source s_mail_orig_forward {\n\
	network(\n\
		ip(\"0.0.0.0\")\n\
		port(9526)\n\
		transport(tcp)\n\
		ip-protocol(4)\n\
		so_rcvbuf(520192)\n\
		log_iw_size(100000)\n\
	);\n\
};\n"
FORWARD_SERVER_CONF_MAILLOG_SOURCE="source s_mail_info_forward {\n\
	network(\n\
		ip(\"0.0.0.0\")\n\
		port(9527)\n\
		transport(tcp)\n\
		ip-protocol(4)\n\
		so_rcvbuf(520192)\n\
		log_iw_size(100000)\n\
		flags(no-parse)\n\
	);\n\
};\n"
FORWARD_SERVER_CONF_SECURITYLOG_SOURCE="source s_mail_security_forward {\n\
	network(\n\
		ip(\"0.0.0.0\")\n\
		port(9528)\n\
		transport(tcp)\n\
		ip-protocol(4)\n\
		so_rcvbuf(520192)\n\
		log_iw_size(100000)\n\
		flags(no-parse)\n\
	);\n\
};\n"
FORWARD_SERVER_CONF_ORIG_DEST="destination d_aggr_maillog_forward {\n\
	file(\"/var/packages/MailPlus-Server/target/var/aggr_log/forwarded/aggr_maillog\"\n\
		perm(0644)\n\
		suppress(0)\n\
);};\n"
FORWARD_SERVER_CONF_MAILLOG_DEST="destination d_aggr_mail_log_forward {\n\
	file(\"/var/packages/MailPlus-Server/target/var/aggr_log/forwarded/aggr_mail_log\"\n\
		perm(0644)\n\
		suppress(0)\n\
		template(\"\${MESSAGE}\\\n\")\n\
);};\n"
FORWARD_SERVER_CONF_SECURITYLOG_DEST="destination d_aggr_security_log_forward {\n\
	file(\"/var/packages/MailPlus-Server/target/var/aggr_log/forwarded/aggr_security_log\"\n\
		perm(0644)\n\
		suppress(0)\n\
		template(\"\${MESSAGE}\\\n\")\n\
);};\n"
FORWARD_SERVER_CONF_ORIG_PATH="log {\n\
	source(s_mail_orig_forward);\n\
	destination(d_aggr_maillog_forward);\n\
};\n"
FORWARD_SERVER_CONF_MAILLOG_PATH="log {\n\
	source(s_mail_info_forward);\n\
	destination(d_aggr_mail_log_forward);\n\
};\n"
FORWARD_SERVER_CONF_SECURITYLOG_PATH="log {\n\
	source(s_mail_security_forward);\n\
	destination(d_aggr_security_log_forward);\n\
};\n"
LOG_SENDING_CONF="destination d_mailplus_server_log_sending {\n\
	SENDING_FORMT(\n\
		\"SENDING_DEST\"\n\
		port(SENDING_PORT)\n\
		transport(SENDING_PROT)\n\
		ip-protocol(4)\n\
		SENDING_ENABLE_SSL\n\
		log_fifo_size(50000)\n\
		suppress(0)\n\
	);\n\
};\n\
log {\n\
	source(src);\n\
	filter(f_mail);\n\
	filter(f_mail_log);\n\
	destination(d_mailplus_server_log_sending);\n\
};\n"

getSoRcvbufSize() {
	local TMP_SO_RCVBUF_SIZE=""
	if [ -f "/proc/sys/net/ipv4/tcp_wmem" ]; then
		TMP_SO_RCVBUF_SIZE=$(cat /proc/sys/net/ipv4/tcp_wmem | awk '{print $3}')
	elif [ -f "/proc/sys/net/ipv4/tcp_mem" ]; then
		TMP_SO_RCVBUF_SIZE=$(cat /proc/sys/net/ipv4/tcp_mem | awk '{print $3}')
	fi

	if [ ! -z "${TMP_SO_RCVBUF_SIZE}" ] ; then
		SO_RCVBUF_SIZE=${TMP_SO_RCVBUF_SIZE}
	fi
}

addForwardSendConf() {
	local FORWARD_OTHER_NODE="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "forward_to_other_node")"
	local CONF_FILE="${CON_DEST_FOLDER}mailserver_log_client.conf"
	if [ "yes" != "${FORWARD_OTHER_NODE}" -o -z "${FORWARD_DEST}" ] ; then 
		return
	fi

	sed -i "/destination d_mail_orig_forward/a${FORWARD_CLIENT_CONF_ORIG}" ${CONF_FILE}
	sed -i "/destination d_mail_info_forward/a${FORWARD_CLIENT_CONF_MAILLOG}" ${CONF_FILE}
	sed -i "/destination d_mail_security_forward/a${FORWARD_CLIENT_CONF_SECURITYLOG}" ${CONF_FILE}
}

addForwardReceiveConf() {
	#return if is not the forward destination or not enable forward
	local FORWARD_OTHER_NODE="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "forward_to_other_node")"
	local NODE_IP="$(getHostIP)"
	local CONF_FILE="${CON_DEST_FOLDER}mailserver_log_client.conf"
	if [ "${NODE_IP}" != "${FORWARD_DEST}" -o "yes" != "${FORWARD_OTHER_NODE}" -o -z "${FORWARD_DEST}" ] || isLoadBalancer; then
		return
	fi

	sed -i "\$a ${FORWARD_SERVER_CONF_ORIG_SOURCE}"  ${CONF_FILE}
	sed -i "\$a ${FORWARD_SERVER_CONF_MAILLOG_SOURCE}"  ${CONF_FILE}
	sed -i "\$a ${FORWARD_SERVER_CONF_SECURITYLOG_SOURCE}"  ${CONF_FILE}
	sed -i "\$a ${FORWARD_SERVER_CONF_ORIG_DEST}"  ${CONF_FILE}
	sed -i "\$a ${FORWARD_SERVER_CONF_MAILLOG_DEST}"  ${CONF_FILE}
	sed -i "\$a ${FORWARD_SERVER_CONF_SECURITYLOG_DEST}"  ${CONF_FILE}
	sed -i "\$a ${FORWARD_SERVER_CONF_ORIG_PATH}"  ${CONF_FILE}
	sed -i "\$a ${FORWARD_SERVER_CONF_MAILLOG_PATH}"  ${CONF_FILE}
	sed -i "\$a ${FORWARD_SERVER_CONF_SECURITYLOG_PATH}"  ${CONF_FILE}
	sed -i "s/so_rcvbuf(520192)/so_rcvbuf($SO_RCVBUF_SIZE)/g" ${CONF_FILE}
}

addLogSendingConf() {
	local FORWARD_OTHER_MACHINE="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "forward_to_other_machine")"
	local SERVER="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "forward_server")"
	local PORT="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "forward_port")"
	local PROTOCOL="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "forward_protocol")"
	local FORMAT="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "forward_format")"
	local ENABLE_SSL="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "forward_enable_ssl")"
	local CONF_FILE=""
	if [ "yes" != "${FORWARD_OTHER_MACHINE}" -o -z "${SERVER}" -o -z "${PORT}" -o -z "${PROTOCOL}" -o -z "${FORMAT}" ] ; then
		return
	fi
	if isLoadBalancer ; then
		CONF_FILE="${CON_DEST_FOLDER}mailserver_log_collector.conf"
	else
		CONF_FILE="${CON_DEST_FOLDER}mailserver_log_client.conf"
	fi
	sed -i "\$a ${LOG_SENDING_CONF}"  ${CONF_FILE}
	if [ "ietf" == "${FORMAT}" ]; then
		sed -i "s/SENDING_FORMT/syslog/g" ${CONF_FILE}
	else
		sed -i "s/SENDING_FORMT/network/g" ${CONF_FILE}
	fi
	sed -i "s/SENDING_DEST/${SERVER}/g" ${CONF_FILE}
	sed -i "s/SENDING_PORT/${PORT}/g" ${CONF_FILE}
	if [ "yes" == "${ENABLE_SSL}" -a "tcp" == "${PROTOCOL}" ]; then
		sed -i "s/SENDING_PROT/tls/g" ${CONF_FILE}
		sed -i "s=SENDING_ENABLE_SSL=tls(ca_dir(\"${SYSLOG_NG_CA_DIR}\"))=g" ${CONF_FILE}
	else
		sed -i "s/SENDING_PROT/${PROTOCOL}/g" ${CONF_FILE}
		sed -i "s/SENDING_ENABLE_SSL//g" ${CONF_FILE}
	fi
}

if isKeyChanged "balancer_master_node" || isKeyChanged "forward_to_other_node" || isKeyChanged "forward_to_other_machine" || isKeyChanged "forward_server" || isKeyChanged "forward_port" || isKeyChanged "forward_protocol" || isKeyChanged "forward_format" || isKeyChanged "forward_enable_ssl" || isTreeChanged "mapping_table"; then
	getSoRcvbufSize
	FORWARD_DEST="$(getNonBalancerNodeIP)"

	rm -f $CON_DEST_FOLDER"mailserver_log_client.conf"
	rm -f $CON_DEST_FOLDER"mailserver_log_collector.conf"
	
	cp "$CONF_SRC_FOLDER""mailserver_log_client.conf" "$CON_DEST_FOLDER"
	sed -i "s/127.0.0.1/$ROLE_BALANCER_MASTER/g" $CON_DEST_FOLDER"mailserver_log_client.conf"
	addForwardSendConf
	sed -i "s/FORWARD_DEST_IP/$FORWARD_DEST/g" $CON_DEST_FOLDER"mailserver_log_client.conf"
	if isLoadBalancer; then
		cp "$CONF_SRC_FOLDER""mailserver_log_collector.conf" $CON_DEST_FOLDER
		sed -i "s/so_rcvbuf(520192)/so_rcvbuf($SO_RCVBUF_SIZE)/g" $CON_DEST_FOLDER"mailserver_log_collector.conf"
		${LOG_DAEMON_SCRIPT} start
	else
		addForwardReceiveConf
		${LOG_DAEMON_SCRIPT} stop
	fi
	addLogSendingConf
	/usr/syno/sbin/synoservice --reload syslog-ng
fi
exit 0
