#!/bin/sh

. /var/packages/MailPlus-Server/target/backend_hook/hookUtils.conf
loadEnv

## Check identity
NODE_ID=$(getHostID)
mailer_servers="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "mailer")"

KEY_DOMAIN_DB="mailserver_domain_db"
KEY_ACTIVE_USER="active_user_list_db"

KEY_CATCH_ALL="catch_all-"
KEY_EN_CATCH_ALL="enable_catch_all-"
KEY_EN_POSTMASTER="enable_postmaster"
KEY_SPAM_ENABLE="spam_enable"
KEY_SPAM_LEARN="spam_auto_learn"
KEY_SPAM_ENABLE_REPORT="spam_report_enable"
KEY_HAM_REPORT="ham_report_account"
KEY_SPAM_REPORT="spam_report_account"
KEY_SMTP_CHANGED_UIDS="smtp_changed_uids"

if ! containString "${NODE_ID}" "${mailer_servers}"; then
	exit 0
fi

if isKeyChanged "${KEY_DOMAIN_DB}"; then
	if ! ${SET_CONF_BINARY} "virtual_domain"; then
		err_log "Failed to set virtual domain map"
		exit 1
	fi
	if ! ${SET_CONF_BINARY} "mimedefang"; then
		err_log "Failed to set mimedefang config"
		exit 1
	fi
	if ! ${SET_CONF_BINARY} "bcc_map"; then
		err_log "Failed to set bcc config"
		exit 1
	fi
	# for dkim regen config and relod service, mimedefeng-disclaimer reload server
	if ! reloadSmtp "${_MAIL_mailserver_trigger_events}"; then
		err_log "Failed to reload smtp"
		exit 1
	fi
	#Action for mimedefang-disclaimer
	if ! ${CALLBACK_BINARY} "rspamd" "${_MAIL_mailserver_trigger_events}"; then
		err_log "Failed to callback rspamd"
		exit 1
	fi
elif isKeyChanged "${KEY_ACTIVE_USER}"; then
	if ! ${SET_CONF_BINARY} "virtual_account"; then
		err_log "Failed to set virtual account map"
		exit 1
	fi
	if ! ${SET_CONF_BINARY} "virtual_alias"; then
		err_log "Failed to set virtual alias map"
		exit 1
	fi
fi
if isPrefixKeyChanged "${KEY_CATCH_ALL}" || isPrefixKeyChanged "${KEY_EN_CATCH_ALL}"; then
	if ! ${SET_CONF_BINARY} "virtual_account"; then
		err_log "Failed to set virtual account map"
		exit 1
	fi
fi

if isKeyChanged "${KEY_HAM_REPORT}" || isKeyChanged "${KEY_SPAM_REPORT}" || isKeyChanged "${KEY_SPAM_ENABLE}" || isKeyChanged "${KEY_SPAM_LEARN}" || isKeyChanged "${KEY_SPAM_ENABLE_REPORT}" || isKeyChanged "${KEY_EN_POSTMASTER}"; then
	if ! ${SET_CONF_BINARY} "virtual_alias"; then
		err_log "Failed to set virtual alias map"
		exit 1
	fi

	if isKeyChanged "${KEY_EN_POSTMASTER}" && ! ${CALLBACK_BINARY} "system_alias" "${_MAIL_mailserver_trigger_events}"; then
		err_log "Failed to run system alias action"
		exit 1
	fi

fi

# notify client after server set config done
if isKeyChanged "${KEY_SMTP_CHANGED_UIDS}"; then
	if ! ${CALLBACK_BINARY} "local_smtp" "${_MAIL_mailserver_trigger_events}"; then
		err_log "Failed to syno_action local_smtp"
		exit 1
	fi
fi

exit 0
