#!/bin/sh
. /var/packages/MailPlus-Server/target/backend_hook/hookUtils.conf
loadEnv

TEMPLATE_FILE="${PRIVATE_LOCATION}/etc/template/dovecot.template"
DOVECOT_CONF="${PRIVATE_LOCATION}/etc/dovecot/dovecot.conf"
DOVECOT_SCRIPT="${PRIVATE_LOCATION}/scripts/daemon/dovecot.sh"
DOVECOT_BIN="${PRIVATE_LOCATION}/sbin/dovecot"

getTrustHosts()
{
	local BALANCER_NODE_ID="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "balancer_master_node")"
	local BALANCER_ADDRESS="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "balancer_address")"
	local IP_LIST=$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "node_ip_list-${BALANCER_NODE_ID}")
	IP_LIST="${IP_LIST} ${BALANCER_ADDRESS}"
	echo "${IP_LIST} 127.0.0.1 ::1"
}

updateDovecotConf()
{
	local TRUST_HOSTS="$(getTrustHosts)"
	cp "${DOVECOT_CONF}" "${DOVECOT_CONF}.$$"
	sed -i "s/#login_trusted_networks =/login_trusted_networks = ${TRUST_HOSTS}/g" "${DOVECOT_CONF}.$$"
	mv "${DOVECOT_CONF}.$$" "${DOVECOT_CONF}"

	# check dovecot status
	${DOVECOT_SCRIPT} status

	# if dovecot status is started, reload it
	if [ $? = 0 ]; then
		${DOVECOT_BIN} reload
	fi
}

## Actions
if containString "node_ip_list-" "${_MAIL_mailserver_trigger_events}"; then
	updateDovecotConf
elif isKeyChanged "balancer_address" || isKeyChanged "balancer_master_node" ; then
	updateDovecotConf
fi

exit 0
