#!/bin/sh
. /var/packages/MailPlus-Server/target/backend_hook/hookUtils.conf
loadEnv

## Actions
if containString "node_ip_list-" "${_MAIL_mailserver_trigger_events}"; then
	masterIP=$(${BACKEND_BINARY} "backend-command" --command "get" --key "/tmp/new_master_ip")
	if [ "" != "${masterIP}" ]; then
		err_log "IP change: Updater masterIP to ${masterIP}"
		${BACKEND_BINARY} "backend-command" --command new_master_ip --newMasterIP "${masterIP}"
	fi

	if ! ${CALLBACK_BINARY} "refresh_firewall" "${_MAIL_mailserver_trigger_events}"; then
		err_log "Failed to update firewall"
		exit 1
	fi
fi

exit 0
