#!/bin/sh
. /var/packages/MailPlus-Server/target/backend_hook/hookUtils.conf
loadEnv

## Check identity
NODE_ID=$(getHostID)
HAPROXY_SCRIPT="/var/packages/MailPlus-Server/target/scripts/daemon/haproxy.sh"
USER_POLICY_SCRIPT="/var/packages/MailPlus-Server/target/backend_hook/scripts/50-PersonalPolicy.py"
smtp_local_only_stat="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "smtpd_send_local_only")"
disable_auto_forward_stat="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "user_policy_disable_auto_forward")"
mailer_servers="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "mailer")"
enable_balancer_address="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "enable_balancer_address")"
if ! containString "${NODE_ID}" "${mailer_servers}"; then
	exit 0
fi

if isKeyChanged "enable_balancer_address"; then
	if [ "${enable_balancer_address}" == "no" ]; then
		## Have to disable haproxy due it may contain port which smtp/s/tls used
		${HAPROXY_SCRIPT} stop
	fi
fi

if isKeyChanged "smtpd_send_local_only"; then
	if ! ${SET_CONF_BINARY} "postfix_policy_setting"; then
		err_log "Failed to set postfix policy main.cf"
		exit 1
	fi
fi

if ([ "${smtp_local_only_stat}" == "yes" ] || [ "${disable_auto_forward_stat}" == "yes" ]) && (isKeyChanged "canonical_domain" || isKeyChanged "smtp_main_domain"); then
	if ! ${USER_POLICY_SCRIPT}; then
		err_log "Failed to set user policy permit_domain"
		exit 1
	fi
fi

if [ "${disable_auto_forward_stat}" == "yes" ] && (isKeyChanged "canonical_domain" || isKeyChanged "smtp_main_domain"); then
	if ! ${USER_POLICY_SCRIPT}; then
		err_log "Failed to set user policy permit_domain"
		exit 1
	fi
fi

if ! reloadSmtp "${_MAIL_mailserver_trigger_events}"; then
	err_log "Failed to reload smtp"
	exit 1
fi

exit 0
