#!/bin/sh
. /var/packages/MailPlus-Server/target/backend_hook/hookUtils.conf
loadEnv

## Check identity
NODE_ID=$(getHostID)
mailer_servers="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "mailer")"
if ! containString "${NODE_ID}" "${mailer_servers}"; then
	exit 0
fi

## Convert syno config
if isKeyChanged "mailserver_global_access_db"; then
	if ! ${SET_CONF_BINARY} "global_access"; then
		err_log "Failed to set conf global_access"
		exit 1
	fi
fi

if isKeyChanged "mailserver_dkim_sign_whitelist_db"; then
	if ! ${SET_CONF_BINARY} "dkim_sign_whitelist"; then
		err_log "Failed to set conf dkim_sign_whitelist"
		exit 1
	fi
fi

## Actions
if isKeyChanged "mailserver_global_access_db"; then
	if ! ${CALLBACK_BINARY} "global_access" "${_MAIL_mailserver_trigger_events}"; then
		err_log "Failed to callback global_access"
		exit 1
	fi
fi

if isKeyChanged "mailserver_dkim_sign_whitelist_db"; then
	if ! ${CALLBACK_BINARY} "dkim_sign_whitelist" "${_MAIL_mailserver_trigger_events}"; then
		err_log "Failed to callback dkim_sign_whitelist"
		exit 1
	fi
fi

exit 0
