#!/bin/sh

# Close STDERR FD
exec 2<&-

GET_CONF_COMMAND="/var/packages/MailPlus-Server/target/bin/syno_mailserver_backend --getConfKeyVal"
MAILSERVER_DB="/var/packages/MailPlus-Server/etc/mailserver.db"
ACCESS_LIST_DB="/var/packages/MailPlus-Server/etc/global_access_list.db"
ALIAS_DB="/var/packages/MailPlus-Server/etc/alias.db"
STATISTIC_DB="/var/packages/MailPlus-Server/target/var/aggr_log/log_statistic.db"

# getDataIfDBExist DB QUERY_STATMENT
getDataIfDBExist()
{
	local DB_PATH=$1
	local QUERY_STATEMENT=$2
	if [ -f "${DB_PATH}" ]; then
		RESULT=`sqlite3 ${DB_PATH} "${QUERY_STATEMENT}"`
	fi
	: ${RESULT:=0}
	echo "${RESULT}"
}

# getDataThroughWebApi API METHOD VERSION
getDataThroughWebApi()
{
	local API=$1
	local METHOD=$2
	local VERSION=$3
	local RESULT="$(synowebapi --exec api=${API} method=${METHOD} version=${VERSION})"
	echo "${RESULT}"
}

# getTopNHourSumFromStat TOP_N_HOUR QUERY_COLUME
getTopNHourSumFromStat()
{
	local TOP_N=$1
	local COLUME=$2
	local TOP_N_HOUR_DATA=`getDataIfDBExist ${STATISTIC_DB} "SELECT SUM(${COLUME}) FROM (SELECT ${COLUME} from log_statistic_hour WHERE time >= ${TIME_YESTERDAY} AND time < ${TIME_TODAY} ORDER BY ${COLUME} DESC limit ${TOP_N});"`
	echo "${TOP_N_HOUR_DATA}"
}

# getSecurityLogCnt QUERY_TYPE
getSecurityLogCnt()
{
	local TYPE=$1
	local SECURITY_LOG_DB="/var/packages/MailPlus-Server/target/var/aggr_log/aggr_security_log.db"
	local SECURITY_LOG_MAIN_DB="/var/packages/MailPlus-Server/target/var/aggr_log/aggr_security_log_main.db"
	local DATA_FROM_DB=`getDataIfDBExist ${SECURITY_LOG_DB} "SELECT COUNT(*) FROM security_log_table WHERE date >= ${TIME_YESTERDAY} AND date < ${TIME_TODAY} AND type='${TYPE}';"`
	local DATA_FROM_MAIN_DB=`getDataIfDBExist ${SECURITY_LOG_MAIN_DB} "SELECT COUNT(*) FROM security_log_table WHERE date >= ${TIME_YESTERDAY} AND date < ${TIME_TODAY} AND type='${TYPE}';"`
	echo $((${DATA_FROM_DB} + ${DATA_FROM_MAIN_DB}))
}

#calRation dividend divisior
calcRatio()
{
	local DIVIDEND=$1
	local DIVISOR=$2
	echo `python -c "print '{0:.2f}'.format(float(${DIVIDEND})/${DIVISOR}) if ${DIVISOR} != 0 else 0"`
}

#count policy list num
countPolicyNum()
{
	local API="SYNO.MailPlusServer.UserGroupPolicy"
	local METHOD="list_policy"
	local VERSION=1
	local POLICY_LIST=`getDataThroughWebApi ${API} ${METHOD} ${VERSION}`
	echo $(echo ${POLICY_LIST} | jq -r '.data|length')
}

#convByteToKB bytes
convByteToKB()
{
	local BYTES=$1
	echo `python -c "print '{0:.2f}'.format(float(${BYTES})/1024)"`
}

getLicenseVar()
{
	local RESULT="$(synowebapi --exec api=SYNO.MailPlusServer.License method='get_user_limit' version=1)"
	local SUCCESS="$(echo "${RESULT}" | jq .success)"
	if [ "${SUCCESS}" == "true" ]; then
		LICENSE_USER_LIMIT="$(echo "${RESULT}" | jq .data.limit)"
	fi

	RESULT="$(synowebapi --exec api=SYNO.MailPlusServer.License method='get_active_user_num' version=1)"
	SUCCESS="$(echo "${RESULT}" | jq .success)"
	if [ "${SUCCESS}" == "true" ]; then
		LICENSE_ACTIVE_USER="$(echo "${RESULT}" | jq .data.total)"
	fi
}

getMCPAction()
{
	local ACTION_STORE="$(${GET_CONF_COMMAND} mcp_enable_store)"
	local ACTION_DELETE="$(${GET_CONF_COMMAND} mcp_enable_delete)"
	local ACTION_DELIVER="$(${GET_CONF_COMMAND} mcp_enable_deliver)"
	local RESULT="no match"

	if [ "${ACTION_STORE}" == "yes" ]; then
		RESULT="store"
	elif [ "${ACTION_DELETE}" == "yes" ]; then
		RESULT="delete"
	elif [ "${ACTION_DELIVER}" == "yes" ]; then
		RESULT="deliver"
	fi

	echo ${RESULT}
}

#getMailPlusVolumeInfo input
getMailPlusVolumeInfo()
{
	local INPUT=$1
	local SHARE_FOLDER_VOLUME=`synoshare --get MailPlus | grep '[^ ]*Path' | grep -Po '(?<=\[)/.*(?=/)'`
	local INFO=`df | grep "\s${SHARE_FOLDER_VOLUME}$" | sed 's|[^ ]* \+\([0-9]\+\) \+\([0-9]\+\) \+\([0-9]\+\) .*|\1 \2 \3|'`
	if [ "${INPUT}" == "capacity" ]; then
		echo $(echo ${INFO} | cut -f1 -d ' ')
	fi
	if [ "${INPUT}" == "free_space" ]; then
		echo $(echo ${INFO} | cut -f3 -d ' ')
	fi
	if [ "${INPUT}" == "cache" ]; then
		local CACHE_X=$(synogetkeyvalue /usr/syno/etc/flashcache.conf ReferencePath | grep "^${SHARE_FOLDER_VOLUME}$")
		[ "${CACHE_X}" != "" ] && echo "true" || echo "false"
	fi
}

#convertToTrueFalse str
convertToTrueFalse()
{
	[ "$1" != "yes" ] && echo "false" || echo "true"
}
MAILPLUS_SERVER_VERSION=`synopkg version MailPlus-Server`
: ${MAILPLUS_SERVER_VERSION:=""}
MAILPLUS_VOLUME_CAPACITY=`getMailPlusVolumeInfo "capacity"`
: ${MAILPLUS_VOLUME_CAPACITY:=0}
MAILPLUS_VOLUME_FREE_SPACE=`getMailPlusVolumeInfo "free_space"`
: ${MAILPLUS_VOLUME_FREE_SPACE:=0}
MAILPLUS_VOLUME_SSD_CACHE_ENABLE=`getMailPlusVolumeInfo "cache"`
: ${MAILPLUS_VOLUME_SSD_CACHE_ENABLE:="false"}
SMTP_ENABLE=`${GET_CONF_COMMAND} smtp_enabled`
ACCOUNT_TYPE=`${GET_CONF_COMMAND} account_type`
SMTP_AUTH_ENABLE=`${GET_CONF_COMMAND} smtp_auth_enabled`
CANONICAL_DOMAIN=`${GET_CONF_COMMAND} canonical_domain`
if [ "${CANONICAL_DOMAIN}" == "" ]; then
    DOMAIN_NUM=0
else
    DOMAIN_NUM=`echo "${CANONICAL_DOMAIN}" | grep -c ","`
    DOMAIN_NUM=$(( ${DOMAIN_NUM} + 1 ))
fi
MSG_LIMIT=`${GET_CONF_COMMAND} message_limit`
: ${MSG_LIMIT:=0}

SMTP_SSL_ENABLE=`${GET_CONF_COMMAND} smtp_ssl_enabled`
SMTP_TLS_ENABLE=`${GET_CONF_COMMAND} smtp_tls_enabled`
SMTP_RELAY_ENABLE=`${GET_CONF_COMMAND} smtp_relay_enabled`
SMTP_NUM_ALIAS=`getDataIfDBExist ${ALIAS_DB} "select count(*) from alias_info_table;"`
SMTP_NUM_BCC_RULE=`getDataIfDBExist ${MAILSERVER_DB} "select count(*) from bcc_table;"`
SMTP_POSTSCREEN_ENABLE=`${GET_CONF_COMMAND} postscreen_enable`
SMTP_POSTSCREEN_DNSBL_SERVERS=`${GET_CONF_COMMAND} postscreen_dnsbl_server`
SMTP_POSTSCREEN_NUM_DNSBL_SERVERS=`${GET_CONF_COMMAND} postscreen_dnsbl_server | awk 'BEGIN {FS=", "} {print NF}'`
: ${SMTP_POSTSCREEN_NUM_DNSBL_SERVERS:=0}
SMTP_POSTSCREEN_DNSBL_THRESHOLD=`${GET_CONF_COMMAND} postscreen_dnsbl_threshold`
: ${SMTP_POSTSCREEN_DNSBL_THRESHOLD:=0}
SMTP_GREYLIST_ENABLE=`${GET_CONF_COMMAND} greylist_enable`
SMTP_GREYLIST_PERIOD=`${GET_CONF_COMMAND} greylist_period`
: ${SMTP_GREYLIST_PERIOD:=0}
SMTP_GREYLIST_NUM_RULE_LIST=`${GET_CONF_COMMAND} greylist_rule_list | awk 'BEGIN {FS=", "} {print NF}'`
: ${SMTP_GREYLIST_NUM_RULE_LIST:=0}
SMTP_MAX_RECIPIENTS=`${GET_CONF_COMMAND} max_recipients_per_mail`
: ${SMTP_MAX_RECIPIENTS:=0}
SMTP_MAX_HOP=`${GET_CONF_COMMAND} max_hops_traveled_per_mail`
: ${SMTP_MAX_HOP:=0}

POP3_ENABLE=`${GET_CONF_COMMAND} pop3_enabled`
POP3S_ENABLE=`${GET_CONF_COMMAND} pop3s_enabled`
IMAP_ENABLE=`${GET_CONF_COMMAND} imap_enabled`
IMAPS_ENABLE=`${GET_CONF_COMMAND} imaps_enabled`

FTS_ENABLE=`${GET_CONF_COMMAND} fts_enabled`
FTS_JIEBA_ENABLE=`${GET_CONF_COMMAND} jieba_enabled`

SPAM_ENABLE=`${GET_CONF_COMMAND} spam_enable`
SPAM_REQUIRED_SCORE=`${GET_CONF_COMMAND} spam_required_score`
: ${SPAM_REQUIRED_SCORE:=0}
SPAM_LEARN_THRESHOLD_SPAM=`${GET_CONF_COMMAND} spam_learn_threshold_spam`
: ${SPAM_LEARN_THRESHOLD_SPAM:=0}
SPAM_LEARN_THRESHOLD_NON_SPAM=`${GET_CONF_COMMAND} spam_learn_threshold_non_spam`
: ${SPAM_LEARN_THRESHOLD_NON_SPAM:=0}
SPAM_AUTO_WHITELIST_ENABLE=`${GET_CONF_COMMAND} spam_auto_whitelist`
SPAM_ENABLE_AUTO_LEARN=`${GET_CONF_COMMAND} spam_auto_learn`
SPAM_NUM_IMPORT_RULES=`ls /var/packages/MailPlus-Server/etc/rules | wc -l`
SPAM_NUM_BLACK_WHITE_LIST=`getDataIfDBExist ${MAILSERVER_DB} "SELECT COUNT(*) FROM blackwhite_table;"`
SPAM_NUM_BLACK_LIST=`getDataIfDBExist ${ACCESS_LIST_DB} "SELECT COUNT(*) FROM blacklist;"`
SPAM_NUM_WHITE_LIST=`getDataIfDBExist ${ACCESS_LIST_DB} "SELECT COUNT(*) FROM whitelist;"`
SPAM_ATTACHMENT_LIMIT_ENABLE=`${GET_CONF_COMMAND} reject_sender_attachment_exceed`
SPAM_ATTACHMENT_LIMIT_SIZE=`${GET_CONF_COMMAND} cleanup_sender_attachment_limit`
: ${SPAM_ATTACHMENT_LIMIT_SIZE:=0}
SPAM_KEYWORDS_ENABLE_NUM=`${GET_CONF_COMMAND} spam_keywords | jq -r '.[].keyword_list[] | .enabled' | grep true | wc -l`
: ${SPAM_KEYWORDS_ENABLE_NUM:=0}
SPAM_KEYWORDS_NUM=`${GET_CONF_COMMAND} spam_keywords | jq -r '.[].keyword_list | length'`
: ${SPAM_KEYWORDS_NUM:=0}
SPAM_LEARN_BY_REPORT_ENABLE=`${GET_CONF_COMMAND} report_autolearn_enable`
SPAM_MIMEDEFANG_DISCLAIMER_ENABLE_NUM=`${GET_CONF_COMMAND} mimedefang_disclaimers | jq -r '.[] | .enabled' | grep true | wc -l`
: ${SPAM_MIMEDEFANG_DISCLAIMER_ENABLE_NUM:=0}
SPAM_MIMEDEFANG_DISCLAIMER_NUM=`${GET_CONF_COMMAND} mimedefang_disclaimers | jq -r '. | length'`
: ${SPAM_MIMEDEFANG_DISCLAIMER_NUM:=0}
SPAM_REPORT_ENABLE=`${GET_CONF_COMMAND} spam_report_enable`
SPAM_DAILY_QUOTA_ENABLE=`${GET_CONF_COMMAND} reject_sasl_sender_rate_exceed`
SPAM_DAILY_FLOW_ENABLE=`${GET_CONF_COMMAND} reject_sender_flow_exceed`
SPAM_DAILY_QUOTA_LIMIT=`${GET_CONF_COMMAND} smtpd_sasl_sender_rate_limit`
: ${SPAM_DAILY_QUOTA_LIMIT:=0}
SPAM_DAILY_FLOW_LIMIT=`${GET_CONF_COMMAND} smtpd_sasl_sender_flow_limit`
: ${SPAM_DAILY_FLOW_LIMIT:=0}

ANTI_VIRUS_ENABLE=`${GET_CONF_COMMAND} anti_virus_enable`
ANTI_VIRUS_ENGINE=`${GET_CONF_COMMAND} anti_virus_engine`
ANTI_VIRUS_EXTRA_SIGNATURE_ENABLE=`${GET_CONF_COMMAND} anti_virus_enable_extra_signature`
ANTI_VIRUS_GOOGLE_SAFEBROWSING_ENABLE=`${GET_CONF_COMMAND} anti_virus_enable_google_safebrowsing`
ANTI_VIRUS_MCAFEE_STATUS=`/var/packages/MailPlus-Server/target/scripts/daemon/synoav_mcafee.sh check_license`
: ${ANTI_VIRUS_MCAFEE_STATUS:="no status"}
ANTI_VIRUS_ACTION=`${GET_CONF_COMMAND} anti_virus_action`
: ${ANTI_VIRUS_ACTION:="unknown action"}
ANTI_VIRUS_PREFIX_ENABLE=`${GET_CONF_COMMAND} anti_virus_enable_rewrite`
: ${ANTI_VIRUS_PREFIX_ENABLE:="no"}

DANGEROUS_CONTENT_SCAN_ENABLE=`${GET_CONF_COMMAND} enable_dangerous_content_scan`

MCP_ENABLE=`${GET_CONF_COMMAND} mcp_enable`
MCP_NUM_RULES=`/var/packages/MailPlus-Server/target/usr/bin/syno-mailplus-server-go-utils backend-command --command list --key mcp_rules_tree | awk '{print NF}'`
: ${MCP_NUM_RULES:=0}
MCP_ACTION=`getMCPAction`
MCP_FORWARD_ENABLE=`${GET_CONF_COMMAND} mcp_enable_forward`
MCP_NOTIFY_USER_ENABLE=`${GET_CONF_COMMAND} mcp_enable_bounce`

SPF_CHECK_ENABLE=`${GET_CONF_COMMAND} enable_spf_check`
DKIM_ENABLE=`${GET_CONF_COMMAND} enable_dkim`
DKIM_SIGN_ENABLE=`${GET_CONF_COMMAND} enable_dkim_sign`
DMARC_ENABLE=`${GET_CONF_COMMAND} enable_dmarc`

DATE_TODAY=`date +"%Y/%m/%d"`
TIME_TODAY=`date -d "${DATE_TODAY}" +%s`
TIME_YESTERDAY=$((${TIME_TODAY} - 86400))

LOG_ARCHIVE_ENABLE=`${GET_CONF_COMMAND} archive_enable_schedule`
LOG_SEND_SYSLOG_ENABLE=`${GET_CONF_COMMAND} forward_to_other_machine`
LOG_SEND_SECONDARY_ENABLE=`${GET_CONF_COMMAND} forward_to_other_node`
LOG_ROTATE_SIZE=`${GET_CONF_COMMAND} rotate_size`
: ${LOG_ROTATE_SIZE:=30}
LOG_ROTATE_ENABLE_PERIOD=`${GET_CONF_COMMAND} rotate_enable_period`
LOG_ROTATE_PERIOD=`${GET_CONF_COMMAND} rotate_period`
: ${LOG_ROTATE_PERIOD:="daily"}

LOG_ACTIVE_SENDER=`getDataIfDBExist ${STATISTIC_DB} "SELECT COUNT(*) FROM log_statistic_daily_usage WHERE type=0 AND time = ${TIME_YESTERDAY};"`
LOG_ACTIVE_RECEIVER=`getDataIfDBExist ${STATISTIC_DB} "SELECT COUNT(*) FROM log_statistic_daily_usage WHERE type=1 AND time = ${TIME_YESTERDAY};"`
LOG_INBOUND_QUANTITY=`getDataIfDBExist ${STATISTIC_DB} "SELECT receiveCnt FROM log_statistic_day WHERE time=${TIME_YESTERDAY};"`
LOG_TOP_10_RECEIVER_QUANTITY=`getDataIfDBExist ${STATISTIC_DB} "SELECT SUM(num) FROM (SELECT num FROM log_statistic_daily_usage WHERE type=1 AND time = ${TIME_YESTERDAY} ORDER BY num DESC limit 10);"`
LOG_TOP_3_HOUR_INBOUND_QUANTITY=`getTopNHourSumFromStat 3 receiveCnt`
LOG_TOP_6_HOUR_INBOUND_QUANTITY=`getTopNHourSumFromStat 6 receiveCnt`
LOG_TOP_12_HOUR_INBOUND_QUANTITY=`getTopNHourSumFromStat 12 receiveCnt`
LOG_OUTBOUND_QUANTITY=`getDataIfDBExist ${STATISTIC_DB} "SELECT sentCnt FROM log_statistic_day WHERE time=${TIME_YESTERDAY};"`
LOG_TOP_10_SENDER_QUANTITY=`getDataIfDBExist ${STATISTIC_DB} "SELECT SUM(num) FROM (SELECT num FROM log_statistic_daily_usage WHERE type=0 AND time = ${TIME_YESTERDAY} ORDER BY num DESC limit 10);"`
LOG_TOP_3_HOUR_OUTBOUND_QUANTITY=`getTopNHourSumFromStat 3 sentCnt`
LOG_TOP_6_HOUR_OUTBOUND_QUANTITY=`getTopNHourSumFromStat 6 sentCnt`
LOG_TOP_12_HOUR_OUTBOUND_QUANTITY=`getTopNHourSumFromStat 12 sentCnt`
LOG_SPAM_QUANTITY=`getSecurityLogCnt spam`
LOG_VIRUS_QUANTITY=`getSecurityLogCnt virus`

LOG_TOP_10_RECEIVER_QUANTITY_RATIO=`calcRatio "${LOG_TOP_10_RECEIVER_QUANTITY}" "${LOG_INBOUND_QUANTITY}"`
LOG_TOP_10_SENDER_QUANTITY_RATIO=`calcRatio "${LOG_TOP_10_SENDER_QUANTITY}" "${LOG_OUTBOUND_QUANTITY}"`
LOG_TOP_3_HOUR_INBOUND_QUANTITY_RATIO=`calcRatio "${LOG_TOP_3_HOUR_INBOUND_QUANTITY}" "${LOG_INBOUND_QUANTITY}"`
LOG_TOP_6_HOUR_INBOUND_QUANTITY_RATIO=`calcRatio "${LOG_TOP_6_HOUR_INBOUND_QUANTITY}" "${LOG_INBOUND_QUANTITY}"`
LOG_TOP_12_HOUR_INBOUND_QUANTITY_RATIO=`calcRatio "${LOG_TOP_12_HOUR_INBOUND_QUANTITY}" "${LOG_INBOUND_QUANTITY}"`
LOG_TOP_3_HOUR_OUTBOUND_QUANTITY_RATIO=`calcRatio "${LOG_TOP_3_HOUR_OUTBOUND_QUANTITY}" "${LOG_OUTBOUND_QUANTITY}"`
LOG_TOP_6_HOUR_OUTBOUND_QUANTITY_RATIO=`calcRatio "${LOG_TOP_6_HOUR_OUTBOUND_QUANTITY}" "${LOG_OUTBOUND_QUANTITY}"`
LOG_TOP_12_HOUR_OUTBOUND_QUANTITY_RATIO=`calcRatio "${LOG_TOP_12_HOUR_OUTBOUND_QUANTITY}" "${LOG_OUTBOUND_QUANTITY}"`

MAX_CONNECTION_SERVICE_CHECK_ENABLE=`${GET_CONF_COMMAND} max_connection_per_min_per_ip_enabled`
MAX_CONNECTION_CREATE_CHECK_ENABLE=`${GET_CONF_COMMAND} max_parallel_connection_per_ip_enabled`
MAX_CONNECTION_SEND_CHECK_ENABLE=`${GET_CONF_COMMAND} max_mails_per_min_per_ip_enabled`
MAX_CONNECTION_SERVICE_NUM=`${GET_CONF_COMMAND} max_connection_per_min_per_ip`
: ${MAX_CONNECTION_SERVICE_NUM:=0}
MAX_CONNECTION_CREATE_NUM=`${GET_CONF_COMMAND} max_parallel_connection_per_ip`
: ${MAX_CONNECTION_CREATE_NUM:=0}
MAX_CONNECTION_SEND_NUM=`${GET_CONF_COMMAND} max_mails_per_min_per_ip`
: ${MAX_CONNECTION_SEND_NUM:=0}

POLICY_NUM=`countPolicyNum`
: ${POLICY_NUM:=0}

CLUSTER_NUM_NODE=`${GET_CONF_COMMAND} cluster_peers | awk '{print NF}'`
: ${CLUSTER_NUM_NODE:=0}
CLUSTER_BALANCER_ENABLE=`${GET_CONF_COMMAND} enable_balancer_address`

MAIL_PLUS_ENABLE=`[ -f /var/packages/MailClient/enabled ] && echo "yes" || echo "no"`
getLicenseVar
: ${LICENSE_USER_LIMIT:=-1}
: ${LICENSE_ACTIVE_USER:=-1}

REPORT_ENABLE=`${GET_CONF_COMMAND} report_enable_report`

echo -n "{"

echo -n \"mailplus_server_version\":\""${MAILPLUS_SERVER_VERSION}"\",
echo -n \"mailplus_volume_capacity\":"${MAILPLUS_VOLUME_CAPACITY}",
echo -n \"mailplus_volume_free_space\":"${MAILPLUS_VOLUME_FREE_SPACE}",
echo -n \"mailplus_volume_ssd_cache_enable\":"${MAILPLUS_VOLUME_SSD_CACHE_ENABLE}",
echo -n \"cluster_num_node\":"${CLUSTER_NUM_NODE}",
echo -n \"cluster_balancer_enable\":$(convertToTrueFalse "${CLUSTER_BALANCER_ENABLE}"),
echo -n \"mail_plus_enable\":$(convertToTrueFalse "${MAIL_PLUS_ENABLE}"),

echo -n \"smtp_enable\":$(convertToTrueFalse "${SMTP_ENABLE}"),
echo -n \"account_type\":\""${ACCOUNT_TYPE}"\",
echo -n \"smtp_auth_enable\":$(convertToTrueFalse "${SMTP_AUTH_ENABLE}"),
echo -n \"domain_num\":"${DOMAIN_NUM}",
echo -n \"msg_limit\":"${MSG_LIMIT}",
echo -n \"smtp_ssl_enable\":$(convertToTrueFalse "${SMTP_SSL_ENABLE}"),
echo -n \"smtp_tls_enable\":$(convertToTrueFalse "${SMTP_TLS_ENABLE}"),
echo -n \"smtp_relay_enable\":$(convertToTrueFalse "${SMTP_RELAY_ENABLE}"),
echo -n \"smtp_num_alias\":"${SMTP_NUM_ALIAS}",
echo -n \"smtp_num_bcc_rule\":"${SMTP_NUM_BCC_RULE}",
echo -n \"smtp_postscreen_enable\":$(convertToTrueFalse "${SMTP_POSTSCREEN_ENABLE}"),
echo -n \"smtp_postscreen_dnsbl_servers\": \""${SMTP_POSTSCREEN_DNSBL_SERVERS}"\",
echo -n \"smtp_postscreen_num_dnsbl_servers\": "${SMTP_POSTSCREEN_NUM_DNSBL_SERVERS}",
echo -n \"smtp_postscreen_dnsbl_threshold\":"${SMTP_POSTSCREEN_DNSBL_THRESHOLD}",
echo -n \"smtp_greylist_enable\":$(convertToTrueFalse "${SMTP_GREYLIST_ENABLE}"),
echo -n \"smtp_greylist_period\":"${SMTP_GREYLIST_PERIOD}",
echo -n \"smtp_greylist_num_rule_list\":"${SMTP_GREYLIST_NUM_RULE_LIST}",
echo -n \"smtp_max_recipients\":"${SMTP_MAX_RECIPIENTS}",
echo -n \"smtp_max_hop\":"${SMTP_MAX_HOP}",

echo -n \"pop3_enable\":$(convertToTrueFalse "${POP3_ENABLE}"),
echo -n \"pop3s_enable\":$(convertToTrueFalse "${POP3S_ENABLE}"),
echo -n \"imap_enable\":$(convertToTrueFalse "${IMAP_ENABLE}"),
echo -n \"imaps_enable\":$(convertToTrueFalse "${IMAPS_ENABLE}"),

echo -n \"fts_enable\":$(convertToTrueFalse "${FTS_ENABLE}"),
echo -n \"fts_jieba_eanble\":$(convertToTrueFalse "${FTS_JIEBA_ENABLE}"),

echo -n \"spam_enable\":$(convertToTrueFalse "${SPAM_ENABLE}"),
echo -n \"spam_required_score\":"${SPAM_REQUIRED_SCORE}",
echo -n \"spam_enable_auto_learn\":$(convertToTrueFalse "${SPAM_ENABLE_AUTO_LEARN}"),
echo -n \"spam_learn_threshold_spam\":"${SPAM_LEARN_THRESHOLD_SPAM}",
echo -n \"spam_learn_threshold_non_spam\":"${SPAM_LEARN_THRESHOLD_NON_SPAM}",
echo -n \"spam_auto_whitelist_enable\":$(convertToTrueFalse "${SPAM_AUTO_WHITELIST_ENABLE}"),
echo -n \"spam_num_import_rules\":"${SPAM_NUM_IMPORT_RULES}",
echo -n \"spam_num_black_white_list\":"${SPAM_NUM_BLACK_WHITE_LIST}",
echo -n \"spam_num_black_list\":"${SPAM_NUM_BLACK_LIST}",
echo -n \"spam_num_white_list\":"${SPAM_NUM_WHITE_LIST}",
echo -n \"spam_attachment_limit_enable\":$(convertToTrueFalse "${SPAM_ATTACHMENT_LIMIT_ENABLE}"),
echo -n \"spam_attachment_limit_size\":"${SPAM_ATTACHMENT_LIMIT_SIZE}",
echo -n \"spam_keywords_enable_num\":"${SPAM_KEYWORDS_ENABLE_NUM}",
echo -n \"spam_keywords_num\":"${SPAM_KEYWORDS_NUM}",
echo -n \"spam_learn_by_report_enable\":$(convertToTrueFalse "${SPAM_LEARN_BY_REPORT_ENABLE}"),
echo -n \"spam_mimedefang_disclaimer_enable_num\":"${SPAM_MIMEDEFANG_DISCLAIMER_ENABLE_NUM}",
echo -n \"spam_mimedefang_disclaimer_num\":"${SPAM_MIMEDEFANG_DISCLAIMER_NUM}",
echo -n \"spam_report_enable\":$(convertToTrueFalse "${SPAM_REPORT_ENABLE}"),
echo -n \"spam_daily_quota_enable\":$(convertToTrueFalse "${SPAM_DAILY_QUOTA_ENABLE}"),
echo -n \"spam_daily_flow_enable\":$(convertToTrueFalse "${SPAM_DAILY_FLOW_ENABLE}"),
echo -n \"spam_daily_quota_limit\":"${SPAM_DAILY_QUOTA_LIMIT}",
echo -n \"spam_daily_flow_limit\":"${SPAM_DAILY_FLOW_LIMIT}",

echo -n \"log_archive_enable\":$(convertToTrueFalse "${LOG_ARCHIVE_ENABLE}"),
echo -n \"log_send_syslog_enable\":$(convertToTrueFalse "${LOG_SEND_SYSLOG_ENABLE}"),
echo -n \"log_send_secondary_enable\":$(convertToTrueFalse "${LOG_SEND_SECONDARY_ENABLE}"),
echo -n \"log_rotate_size\":"${LOG_ROTATE_SIZE}",
echo -n \"log_rotate_enable_period\":$(convertToTrueFalse "${LOG_ROTATE_ENABLE_PERIOD}"),
echo -n \"log_rotate_period\":\""${LOG_ROTATE_PERIOD}"\",
echo -n \"log_active_sender\":"${LOG_ACTIVE_SENDER}",
echo -n \"log_active_receiver\":"${LOG_ACTIVE_RECEIVER}",
echo -n \"log_inbound_quantity\":"${LOG_INBOUND_QUANTITY}",
echo -n \"log_outbound_quantity\":"${LOG_OUTBOUND_QUANTITY}",
echo -n \"log_top_10_receiver_quantity_ratio\":"${LOG_TOP_10_RECEIVER_QUANTITY_RATIO}",
echo -n \"log_top_10_sender_quantity_ratio\":"${LOG_TOP_10_SENDER_QUANTITY_RATIO}",
echo -n \"log_top_3_hour_inbound_quantity_ratio\":"${LOG_TOP_3_HOUR_INBOUND_QUANTITY_RATIO}",
echo -n \"log_top_6_hour_inbound_quantity_ratio\":"${LOG_TOP_6_HOUR_INBOUND_QUANTITY_RATIO}",
echo -n \"log_top_12_hour_inbound_quantity_ratio\":"${LOG_TOP_12_HOUR_INBOUND_QUANTITY_RATIO}",
echo -n \"log_top_3_hour_outbound_quantity_ratio\":"${LOG_TOP_3_HOUR_OUTBOUND_QUANTITY_RATIO}",
echo -n \"log_top_6_hour_outbound_quantity_ratio\":"${LOG_TOP_6_HOUR_OUTBOUND_QUANTITY_RATIO}",
echo -n \"log_top_12_hour_outbound_quantity_ratio\":"${LOG_TOP_12_HOUR_OUTBOUND_QUANTITY_RATIO}",
echo -n \"log_spam_quantity\":"${LOG_SPAM_QUANTITY}",
echo -n \"log_virus_quantity\":"${LOG_VIRUS_QUANTITY}",

echo -n \"anti_virus_enable\":$(convertToTrueFalse "${ANTI_VIRUS_ENABLE}"),
echo -n \"anti_virus_engine\":\""${ANTI_VIRUS_ENGINE}"\",
echo -n \"anti_virus_extra_signature_enable\":$(convertToTrueFalse "${ANTI_VIRUS_EXTRA_SIGNATURE_ENABLE}"),
echo -n \"anti_virus_google_safebrowsing_enable\":$(convertToTrueFalse "${ANTI_VIRUS_GOOGLE_SAFEBROWSING_ENABLE}"),
echo -n \"anti_virus_mcafee_status\":\""${ANTI_VIRUS_MCAFEE_STATUS}"\",
echo -n \"anti_virus_action\":\""${ANTI_VIRUS_ACTION}"\",
echo -n \"anti_virus_prefix_enable\":$(convertToTrueFalse "${ANTI_VIRUS_PREFIX_ENABLE}"),

echo -n \"mcp_enable\":$(convertToTrueFalse "${MCP_ENABLE}"),
echo -n \"mcp_num_rules\":"${MCP_NUM_RULES}",
echo -n \"mcp_action\":\""${MCP_ACTION}"\",
echo -n \"mcp_forward_enable\":$(convertToTrueFalse "${MCP_FORWARD_ENABLE}"),
echo -n \"mcp_notify_user_enable\":$(convertToTrueFalse "${MCP_NOTIFY_USER_ENABLE}"),

echo -n \"dangerous_content_scan_enable\":$(convertToTrueFalse "${DANGEROUS_CONTENT_SCAN_ENABLE}"),
echo -n \"spf_check_enable\":$(convertToTrueFalse "${SPF_CHECK_ENABLE}"),
echo -n \"dkim_enable\":$(convertToTrueFalse "${DKIM_ENABLE}"),
echo -n \"dkim_sign_enable\":$(convertToTrueFalse "${DKIM_SIGN_ENABLE}"),
echo -n \"dmarc_enable\":$(convertToTrueFalse "${DMARC_ENABLE}"),
echo -n \"report_enable\":$(convertToTrueFalse "${REPORT_ENABLE}"),

echo -n \"license_user_limit\":"${LICENSE_USER_LIMIT}",
echo -n \"license_active_user\":"${LICENSE_ACTIVE_USER}",

echo -n \"max_connection_service_check_enable\":$(convertToTrueFalse "${MAX_CONNECTION_SERVICE_CHECK_ENABLE}"),
echo -n \"max_connection_service_num\":"${MAX_CONNECTION_SERVICE_NUM}",
echo -n \"max_connection_create_check_enable\":$(convertToTrueFalse "${MAX_CONNECTION_CREATE_CHECK_ENABLE}"),
echo -n \"max_connection_create_num\":"${MAX_CONNECTION_CREATE_NUM}",
echo -n \"max_connection_send_check_enable\":$(convertToTrueFalse "${MAX_CONNECTION_SEND_CHECK_ENABLE}"),
echo -n \"max_connection_send_num\":"${MAX_CONNECTION_SEND_NUM}",

echo -n \"policy_num\":"${POLICY_NUM}",

# let version be the last one msg
echo -n \"collector_version\":2
echo "}"

exit 0
