#!/bin/sh

. /var/packages/MailPlus-Server/target/scripts/daemon/util.sh

SASLAUTHD_BIN=${MAIL_SERVER_PKG}/target/sbin/saslauthd
SASLAUTHD_PID=/var/run/saslauthd/saslauthd.pid

bin_status()
{
	#check SASLAuthd
	checkPidFileStatus "saslauthd" "${SASLAUTHD_PID}"
	return $?
}

conf_status()
{
	checkConfKey "smtp_enabled"
	return $?
}

status()
{
	conf_status
	local saslauthd_enable=$?
	bin_status
	local saslauthd_status=$?

	if [ "${SERVICE_NOT_RUNNING}" -eq ${saslauthd_status} ] && [ "${RUNKEY_DISABLE}" -ne "${saslauthd_enable}" ]; then
		return "${SERVICE_UNKNOWN}"
	elif [ "${SERVICE_RUNNING}" -eq ${saslauthd_status} ] && [ "${RUNKEY_ENABLE}" -ne "${saslauthd_enable}" ]; then
		return "${SERVICE_UNKNOWN}"
	fi
	return ${saslauthd_status}
}

start()
{
	echo "Starting SASLAuthd..."
	${SASLAUTHD_BIN} -a pam

	local daemon_status=""
	for i in `seq 0 1 "${MAX_TRY_TIMES}"`
	do
		status
		daemon_status=$?
		debug_log "daemon_status saslauthd: ${daemon_status}"
		if [ ${daemon_status} -eq "${SERVICE_RUNNING}" ]; then
			#binary is ready
			return 0
		elif [ ${daemon_status} -eq "${SERVICE_DEAD_FPID}" ]; then
			#[FIXME] Maybe we can do something to recover
			return 1
		else
			sleep "${SLEEP_TIME}"
		fi
	done
	return 1
}

stop()
{
	if [ -f ${SASLAUTHD_PID} ]; then
		echo "Stopping SASLAuthd..."
		kill `cat ${SASLAUTHD_PID}`
	fi
}

restart() {
	stop
	sleep 1
	start
}

reload() {
	echo "Reload Saslauthd..."
	bin_status
	ret=$?

	if [ ${ret} -eq "${SERVICE_NOT_RUNNING}" ]; then
		start
	fi
}

composePID()
{
	local pid=$(cat ${SASLAUTHD_PID} | sed -e 's/^[[:space:]]*//' -e 's/[[:space:]]*$//')
	echo "${pid}"
}

composeScript()
{
	echo "/var/packages/MailPlus-Server/target/scripts/daemon/saslauthd.sh"
}

case "$1" in
	start)
		startOperation "mailserver_service_saslauthd"
		;;
	restart)
		restartOperation "mailserver_service_saslauthd"
		;;
	stop)
		stopOperation "mailserver_service_saslauthd"
		;;
	reload)
		reloadOperation "mailserver_service_saslauthd"
		;;
	status)
		status
		;;
	*)
		echo "Usage: $0 {start|stop|restart|status}" >&2
		exit 1
		;;
esac
