#!/bin/sh

. /var/packages/MailPlus-Server/target/scripts/daemon/util.sh

POSTFIX_BIN="${MAIL_SERVER_PKG}/target/sbin/postfix"
POSTFIX_PID="/var/spool/@MailPlus-Server/postfix/pid/master.pid"
POSTFIX_CONF="${MAIL_SERVER_PKG}/target/etc/master.cf"

## FIXME: it seems postfix stop would not always remove the lock file and would caused start failed
LOCK_FILE="/var/lib/postfix/master.lock"

bin_status()
{
	#check Postfix related service
	checkPidFileStatus "master" "${POSTFIX_PID}"
	return $?
}

conf_status()
{
	checkConfKey "smtp_enabled"
	return $?
}

port_status()
{
	#[FIXME] The get port has no flexible. should change
	local ports=`cat "${POSTFIX_CONF}" | grep "inet" | grep -v "#" | grep -v "\-o" | awk -F" " '{print $1}'`
	local line=""
	for line in ${ports}; do
		checkPortUseStatus "master" "${line}" "0.0.0.0"
		local port_status=$?
		if [ "${SERVICE_RUNNING}" -eq ${port_status} ] ; then
			continue
		fi
		checkPortUseStatus "smtpd" "${line}" "0.0.0.0"
		local port_status=$?
		if [ "${SERVICE_RUNNING}" -ne ${port_status} ] ; then
			return ${port_status}
		fi
	done
	return "${SERVICE_RUNNING}"
}

status()
{
	conf_status
	local postfix_enable=$?
	bin_status
	local postfix_status=$?

	if [ "${SERVICE_NOT_RUNNING}" -eq ${postfix_status} ] && [ "${RUNKEY_DISABLE}" -ne "${postfix_enable}" ]; then
		return "${SERVICE_UNKNOWN}"
	elif [ "${SERVICE_RUNNING}" -eq ${postfix_status} ] && [ "${RUNKEY_ENABLE}" -ne "${postfix_enable}" ]; then
		return "${SERVICE_UNKNOWN}"
	fi
	
	if [ "${SERVICE_RUNNING}" -ne ${postfix_status} ]; then
		return ${postfix_status}
	fi

	port_status
	local postfix_port=$?
	return ${postfix_port}
}

start() {
	echo "Starting Postfix..."
	${POSTFIX_BIN} start

	local daemon_status=""
	for i in `seq 0 1 "${MAX_TRY_TIMES}"`
	do
		status
		daemon_status=$?
		debug_log "daemon_status postfix: ${daemon_status}"
		if [ ${daemon_status} -eq "${SERVICE_RUNNING}" ]; then
			#binary is ready
			return 0
		elif [ ${daemon_status} -eq "${SERVICE_DEAD_FPID}" ]; then
			#[FIXME] Maybe we can do something to recover
			return 1
		else
			sleep "${SLEEP_TIME}"
		fi
	done
	return 1
}

stop() {
	echo "Stopping Postfix..."
	${POSTFIX_BIN} stop
	rm ${LOCK_FILE} &> /dev/null
	rm ${POSTFIX_PID} &> /dev/null
}

restart() {
	stop
	sleep 1
	start
}

reload() {
	echo "Reload Postfix..."
	bin_status
	local ret=$?
	if [ ${ret} -eq "${SERVICE_RUNNING}" ]; then
		${POSTFIX_BIN} reload
	else
		restart
	fi
}

composePort()
{
	local ports=()

	local postfix_ports=`cat "${POSTFIX_CONF}" | grep "inet" | grep -v "#" | grep -v "\-o" | awk -F" " '{print $1}'`
	for port in ${postfix_ports}; do
		if [ x"" == x"${port}" ]; then
			continue
		fi
		ports[${#ports[*]}]=${port}
	done

	echo "$(IFS=, ; echo "${ports[*]}")"
}

composeIP()
{
	echo "0.0.0.0"
}

composeProtocol()
{
	echo "tcp"
}

composePID()
{
	local pid=$(cat ${POSTFIX_PID} | sed -e 's/^[[:space:]]*//' -e 's/[[:space:]]*$//')
	echo "${pid}"
}

composeScript()
{
	echo "/var/packages/MailPlus-Server/target/scripts/daemon/postfix.sh"
}


case "$1" in
	start)
		startOperation "mailserver_service_postfix"
		;;
	restart)
		restartOperation "mailserver_service_postfix"
		;;
	stop)
		stopOperation "mailserver_service_postfix"
		;;
	reload)
		reloadOperation "mailserver_service_postfix"
		;;
	status)
		status
		;;
	*)
		echo "Usage: $0 {start|stop|reload|status}" >&2
		exit 1
		;;
esac
