#!/bin/sh

. /var/packages/MailPlus-Server/target/scripts/daemon/util.sh

MIMEDEFANG_LOCK="/var/lock/mailplus_server/mimedefang.lock"
MIMEDEFANG_SPOOL="/var/spool/@MailPlus-Server/MIMEDefang"
MIMEDEFANG_SOCK="${MIMEDEFANG_SPOOL}/mimedefang.sock"
MIMEDEFANG_PID="/var/run/mailplus_server/mimedefang.pid"

MULTIPLEXOR_SOCK="${MIMEDEFANG_SPOOL}/multiplexor.sock"
MULTIPLEXOR_STATUS_SOCK="${MIMEDEFANG_SPOOL}/multiplexor-status.sock"
MULTIPLEXOR_NOTIFICATION_SOCK="${MIMEDEFANG_SPOOL}/multiplexor-notification.sock"
MULTIPLEXOR_PID="/var/run/mailplus_server/mimedefang-multiplexor.pid"
MULTIPLEXOR_SLAVE_NUM="5" # FIXME: need tune slave number

MD_MX_CTRL="${MAIL_SERVER_PKG}/target/bin/md-mx-ctrl"

MIMEDEFANG_BIN="${MAIL_SERVER_PKG}/target/bin/mimedefang "\
"-U MailPlus-Server "\
"-z ${MIMEDEFANG_SPOOL} "\
"-p ${MIMEDEFANG_SOCK} "\
"-m ${MULTIPLEXOR_SOCK} "\
"-G "\
"-q "\
"-k "\
"-P ${MIMEDEFANG_PID} "\
"-X "\
"-N "\
"-S mail "

MULTIPLEXOR_BIN="${MAIL_SERVER_PKG}/target/bin/mimedefang-multiplexor "\
"-U MailPlus-Server "\
"-x ${MULTIPLEXOR_SLAVE_NUM} "\
"-b 300 "\
"-Z "\
"-z ${MIMEDEFANG_SPOOL} "\
"-s ${MULTIPLEXOR_SOCK} "\
"-a ${MULTIPLEXOR_STATUS_SOCK} "\
"-p ${MULTIPLEXOR_PID} "\
"-l "\
"-q 128 "\
"-O ${MULTIPLEXOR_NOTIFICATION_SOCK} "\
"-S mail "\
"-E "\
"-G "

checkStarted()
{
	if [ -f ${MIMEDEFANG_PID} ]; then
		PID=`cat ${MIMEDEFANG_PID}`
		PROCESS=`cat "/proc/${PID}/cmdline" | grep mimedefang`
	fi

	if [ ! -z "${PROCESS}" ]; then
		return 1
	fi
	return 0
}

bin_status()
{
	checkPidFileStatus "mimedefang" "${MIMEDEFANG_PID}"
}

conf_status()
{
	checkConfKey "mimedefang_enable"
	return $?
}

status()
{
	conf_status
	local mimedefang_enable=$?
	bin_status
	local mimedefang_status=$?

	if [ "${SERVICE_NOT_RUNNING}" -eq ${mimedefang_status} ] && [ "${RUNKEY_DISABLE}" -ne "${mimedefang_enable}" ]; then
		return "${SERVICE_UNKNOWN}"
	elif [ "${SERVICE_RUNNING}" -eq ${mimedefang_status} ] && [ "${RUNKEY_ENABLE}" -ne "${mimedefang_enable}" ]; then
		return "${SERVICE_UNKNOWN}"
	fi
	return ${mimedefang_status}
}

runDaemon()
{
	rm -f ${MIMEDEFANG_SOCK}
	rm -f ${MULTIPLEXOR_SOCK}
	rm -f ${MULTIPLEXOR_STATUS_SOCK}
	rm -f ${MULTIPLEXOR_NOTIFICATION_SOCK}

	export "PERL5LIB=/var/packages/MailPlus-Server/target/lib/MIMEDefang:/var/packages/MailPlus-Server/target/lib/perl5/vendor_perl:/var/packages/MailPlus-Server/target/lib/perl5/core_perl:/var/packages/MailPlus-Server/target/share/perl5/vendor_perl"

	${MULTIPLEXOR_BIN}
	${MIMEDEFANG_BIN}

	# FIXME: need to check multiplexor status ?

	local daemon_status=""
	for i in `seq 0 1 "${MAX_TRY_TIMES}"`
	do
		status
		daemon_status=$?
		debug_log "daemon_status mimedefang: ${daemon_status}"
		if [ ${daemon_status} -eq "${SERVICE_RUNNING}" ]; then
			#binary is ready
			return 0
		elif [ ${daemon_status} -eq "${SERVICE_DEAD_FPID}" ]; then
			#[FIXME] Maybe we can do something to recover
			return 1
		else
			sleep "${SLEEP_TIME}"
		fi
	done
	return 1
}

start()
{
	(
	if flock -x 8; then
		checkStarted
		if [ 1 -eq $? ] ; then
			echo "mimedefang is already running"
		else
			runDaemon
		fi

		flock -u 8
		rm ${MIMEDEFANG_LOCK}
	fi
	)8> ${MIMEDEFANG_LOCK}
}

checkStopped()
{
	# FIXME: need to check multiplexor status ?

	for i in `seq 0 1 "${MAX_TRY_TIMES}"`
	do
		if ! pidof mimedefang > /dev/null; then
			# mimedefang is terminated
			break
		fi
		sleep "${SLEEP_TIME}"
	done

	# if mimedefang still exists, force stop it
	if pidof mimedefang > /dev/null; then
		killall -9 mimedefang
	fi
}

stopDaemon()
{
	kill `cat ${MULTIPLEXOR_PID}`
	kill `cat ${MIMEDEFANG_PID}`
	checkStopped
	rm -f ${MULTIPLEXOR_NOTIFICATION_SOCK}
	rm -f ${MULTIPLEXOR_PID}
	rm -f ${MIMEDEFANG_PID}
}

stop()
{
	(
	if flock -x 8; then
		stopDaemon

		flock -u 8
		rm ${MIMEDEFANG_LOCK}
	fi
	)8> ${MIMEDEFANG_LOCK}
}

restart()
{
	(
	if flock -x 8; then
		stopDaemon
		sleep 1
		runDaemon

		flock -u 8
		rm ${MIMEDEFANG_LOCK}
	fi
	)8> ${MIMEDEFANG_LOCK}
}

reload()
{
	${MD_MX_CTRL} -s ${MULTIPLEXOR_SOCK} reread
}

composePID()
{
	local pid=$(cat ${MIMEDEFANG_PID} | sed -e 's/^[[:space:]]*//' -e 's/[[:space:]]*$//')
	echo "${pid}"
}

composeScript()
{
	echo "/var/packages/MailPlus-Server/target/scripts/daemon/mimedefang.sh"
}


case "$1" in
	start)
		startOperation "mailserver_service_mimedefang"
		;;
	restart)
		restartOperation "mailserver_service_mimedefang"
		;;
	stop)
		stopOperation "mailserver_service_mimedefang"
		;;
	reload)
		reloadOperation "mailserver_service_mimedefang"
		;;
	status)
		status
		;;
	*)
		echo "Usage: $0 {start|stop|restart|status}" >&2
		exit 1
		;;
esac
