#!/bin/sh

. /var/packages/MailPlus-Server/target/scripts/daemon/util.sh

MAILSCANNER_PID="/var/run/mailplus_server/MailScanner.pid"
MAILSCANNER="${MAIL_SERVER_PKG}/target/bin/MailScanner/MailScanner"
SZF_MAILSCANNER_LOCK="/tmp/syno_mailscanner.lock"
MAILSCANNER_DB_PATH="/var/run/mailplus_server/MailScanner"

checkStarted()
{
	if [ -f ${MAILSCANNER_PID} ]; then
		PID=`cat ${MAILSCANNER_PID}`
		PROCESS=`cat "/proc/${PID}/cmdline" | grep MailScanner`
	fi

	if [ ! -z "${PROCESS}" ]; then 
		return 1
	fi
	return 0
}

bin_status()
{
	local status

	checkStarted
	if [ 1 -eq $? ] ; then
		status="${SERVICE_RUNNING}"
	else
		status="${SERVICE_NOT_RUNNING}"
	fi

	return "${status}"
}

conf_status()
{
	checkConfKey "anti_virus_enable"
	if [ "${RUNKEY_ENABLE}" -eq $? ]; then
		return "${RUNKEY_ENABLE}"
	fi
	checkConfKey "spam_enable"
	if [ "${RUNKEY_ENABLE}" -eq $? ]; then
		return "${RUNKEY_ENABLE}"
	fi
	checkConfKey "enable_dangerous_content_scan"
	if [ "${RUNKEY_ENABLE}" -eq $? ]; then
		return "${RUNKEY_ENABLE}"
	fi
	return "${RUNKEY_DISABLE}"
}

status()
{
	conf_status
	local mailscanner_enable=$?
	bin_status
	local mailscanner_status=$?

	if [ "${SERVICE_NOT_RUNNING}" -eq ${mailscanner_status} ] && [ "${RUNKEY_DISABLE}" -ne "${mailscanner_enable}" ]; then
		return "${SERVICE_UNKNOWN}"
	elif [ "${SERVICE_RUNNING}" -eq ${mailscanner_status} ] && [ "${RUNKEY_ENABLE}" -ne "${mailscanner_enable}" ]; then
		return "${SERVICE_UNKNOWN}"
	fi
	return ${mailscanner_status}
}

reloadDaemon()
{
	kill -s HUP `cat ${MAILSCANNER_PID}`
}

runDaemon()
{
	if [ ! -d ${MAILSCANNER_DB_PATH} ]; then
		mkdir -p ${MAILSCANNER_DB_PATH}
		chown postfix ${MAILSCANNER_DB_PATH}
	fi
	export "PERL5LIB=/var/packages/MailPlus-Server/target/lib/perl5/vendor_perl:/var/packages/MailPlus-Server/target/lib/perl5/core_perl:/var/packages/MailPlus-Server/target/share/perl5/vendor_perl"
	${MAILSCANNER}

	local daemon_status=""
	for i in `seq 0 1 "${MAX_TRY_TIMES}"`
	do
		status
		daemon_status=$?
		debug_log "daemon_status mailscanner: ${daemon_status}"
		if [ ${daemon_status} -eq "${SERVICE_RUNNING}" ]; then
			#binary is ready
			return 0
		elif [ ${daemon_status} -eq "${SERVICE_DEAD_FPID}" ]; then
			#[FIXME] Maybe we can do something to recover
			return 1
		else
			sleep "${SLEEP_TIME}"
		fi
	done
	return 1
}

start()
{
	(
	if flock -x 8; then
		checkStarted
		if [ 1 -eq $? ] ; then
			echo "MailScanner is already running"
		else
			runDaemon
		fi

		flock -u 8
		rm ${SZF_MAILSCANNER_LOCK}
	fi
	)8> ${SZF_MAILSCANNER_LOCK}
}

restart()
{
	(
	if flock -x 8; then
		checkStarted
		if [ 1 -eq $? ] ; then
			reloadDaemon
		else
			runDaemon
		fi

		flock -u 8
		rm ${SZF_MAILSCANNER_LOCK}
	fi
	)8> ${SZF_MAILSCANNER_LOCK}
}

stop()
{
	kill `cat ${MAILSCANNER_PID}`
	rm ${MAILSCANNER_PID} &> /dev/null
}

reload()
{
	reloadDaemon
}

composePID()
{
	local pid=$(cat ${MAILSCANNER_PID} | sed -e 's/^[[:space:]]*//' -e 's/[[:space:]]*$//')
	echo "${pid}"
}

composeScript()
{
	echo "/var/packages/MailPlus-Server/target/scripts/daemon/mailscanner.sh"
}

case "$1" in
	start)
		startOperation "mailserver_service_mailscanner"
		;;
	restart)
		restartOperation "mailserver_service_mailscanner"
		;;
	stop)
		stopOperation "mailserver_service_mailscanner"
		;;
	reload)
		reloadOperation "mailserver_service_mailscanner"
		;;
	status)
		status
		;;
esac
