#!/bin/sh

. /var/packages/MailPlus-Server/target/scripts/daemon/util.sh

GREYLIST_PID="/var/run/mailplus_server/milter-greylist.pid"
GREYLIST_LOCK="/var/lock/mailplus_server/greylist.lock"
GREYLIST_SOCK="/var/spool/@MailPlus-Server/postfix/milter-greylist/milter-greylist.sock"
GREYLIST_PORT=5252

bin_status()
{
	checkPidFileStatus "milter-greylist" "${GREYLIST_PID}"
}

conf_status()
{
	checkConfKey "spam_greylist_enable"
}

port_status()
{
	checkPortUseStatus "milter-greylist" "${GREYLIST_PORT}" "0.0.0.0"
}

status()
{
	conf_status
	local greylist_enable=$?
	bin_status
	local greylist_status=$?

	if [ "${SERVICE_NOT_RUNNING}" -eq ${greylist_status} ] && [ "${RUNKEY_DISABLE}" -ne "${greylist_enable}" ]; then
		return "${SERVICE_UNKNOWN}"
	elif [ "${SERVICE_RUNNING}" -eq ${greylist_status} ] && [ "${RUNKEY_ENABLE}" -ne "${greylist_enable}" ]; then
		return "${SERVICE_UNKNOWN}"
	fi
	if [ "${SERVICE_RUNNING}" -ne ${greylist_status} ]; then
		return ${greylist_status}
	fi
	port_status
	local greylist_port=$?
	return ${greylist_port}
}

runDaemon() {
	rm -f "${GREYLIST_SOCK}"
	chown postfix:root /var/packages/MailPlus-Server/target/var/milter-greylist
	/var/packages/MailPlus-Server/target/bin/milter-greylist

	local daemon_status=""
	for i in `seq 0 1 "${MAX_TRY_TIMES}"`
	do
		status
		daemon_status=$?
		debug_log "daemon_status greylist: ${daemon_status}"
		if [ ${daemon_status} -eq "${SERVICE_RUNNING}" ]; then
			#binary is ready
			return 0
		elif [ ${daemon_status} -eq "${SERVICE_DEAD_FPID}" ]; then
			#[FIXME] Maybe we can do something to recover
			return 1
		else
			sleep "${SLEEP_TIME}"
		fi
	done
	return 1
}

start()
{
	(
	if flock -x 8; then
		bin_status
		if [ "${SERVICE_RUNNING}" -eq $? ] ; then
			echo "greylist is already running"
		else
			runDaemon
		fi

		flock -u 8
		rm ${GREYLIST_LOCK}
	fi
	)8> ${GREYLIST_LOCK}
}

check_greylist_stopped() {
	# make sure the process is stopped
	for i in `seq 0 1 "${MAX_TRY_TIMES}"`
	do
		if ! pidof milter-greylist > /dev/null; then
			break
		fi
		sleep "${SLEEP_TIME}"
	done

	# if milter-greylist still exists, force stop it
	if pidof milter-greylist > /dev/null; then
		killall -9 milter-greylist
	fi
}

stopDaemon()
{
	killall milter-greylist
	check_greylist_stopped
	rm "${GREYLIST_PID}"
}

stop() {
	(
	if flock -x 8; then
		stopDaemon

		flock -u 8
		rm ${GREYLIST_LOCK}
	fi
	)8> ${GREYLIST_LOCK}
}

restart() {
	(
	if flock -x 8; then
		stopDaemon
		sleep 1
		runDaemon

		flock -u 8
		rm ${GREYLIST_LOCK}
	fi
	)8> ${GREYLIST_LOCK}
}


composePort()
{
	echo "${GREYLIST_PORT}"
}

composeIP()
{
	echo "0.0.0.0"
}

composeProtocol()
{
	echo "tcp"
}

composePID()
{
	local pid=$(cat ${GREYLIST_PID} | sed -e 's/^[[:space:]]*//' -e 's/[[:space:]]*$//')
	echo "${pid}"
}

composeScript()
{
	echo "/var/packages/MailPlus-Server/target/scripts/daemon/greylist.sh"
}


case "$1" in
	start)
		startOperation "mailserver_service_greylist"
		;;
	restart)
		restartOperation "mailserver_service_greylist"
		;;
	stop)
		stopOperation "mailserver_service_greylist"
		;;
	status)
		status
		;;
	*)
		echo "Usage: $0 {start|stop|restart|status}"
		exit 1
		;;
esac
