#!/bin/sh

. /var/packages/MailPlus-Server/target/backend_hook/hookUtils.conf
. /var/packages/MailPlus-Server/target/scripts/daemon/util.sh

DOVECOT_NAME="dovecot"
DOVECOT_BIN="${MAIL_SERVER_PKG}/target/sbin/dovecot"
DOVECOT_BASE=`${DOVECOT_BIN} -a|grep '^base_dir = '|sed 's/^base_dir = //'`
DOVECOT_PID="${DOVECOT_BASE}/master.pid"
DOVEADM_BIN="${MAIL_SERVER_PKG}/target/bin/doveadm"
DOVECOT_GROUP_CACHE_UPGRADE="${MAIL_SERVER_PKG}/target/bin/syno_gen_dovecot_group_cache"

MAILPLUS_SERVER_PORT_PATH="/usr/local/etc/services.d/mailplus_server_port"
GET_SECTION_KEY_VALUE="/usr/syno/bin/get_section_key_value"

get_port()
{
	local port_section=$1
	echo `"${GET_SECTION_KEY_VALUE}" "${MAILPLUS_SERVER_PORT_PATH}" "${port_section}" dst.ports | awk -F"/" 'NR == 1 {print $1}'`
}

checkDovecotStatus()
{
	local target_proc_name=$1
	local target_pid_file=$2
	local noneed_filter=$3
	#echo " checkDirectorStatus ----- ${target_proc_name} ---- ${target_pid_file} ----- ${noneed_filter} ----- "
	if [ x"`/bin/pidof "${target_proc_name}"`" != x"" ] ; then
		if [ -f "${target_pid_file}" ] ; then
			local pid=`cat "${target_pid_file}"`
			if [ 0 != `ps -I | grep "${target_proc_name}" | grep -v "${noneed_filter}" | grep "${pid}" | wc -l` ] ; then
				#echo "I'm running"
				return "${SERVICE_RUNNING}"
			else
				return "${SERVICE_DEAD_FPID}"
			fi
		else
			#grep will has one process
			if [ 0 != `ps -I | grep "${target_proc_name}" | grep -v "grep" | grep -v "${noneed_filter}" | grep -v "dovecot.sh" | wc -l` ] ; then
				#echo "I'm running"
				return "${SERVICE_RUNNING}"
			else
				#echo "I'm not running"
				return "${SERVICE_NOT_RUNNING}"
			fi
		fi
	else
		if [ -f "${target_pid_file}" ] ; then
			return "${SERVICE_DEAD_FPID}"
		else
			#echo "I'm not running"
			return "${SERVICE_NOT_RUNNING}"
		fi
	fi > /dev/null
}

checkDovecotPortUseStatus()
{
	local target_proc=$1
	local target_port=$2
	local target_ip=$3

	#echo " checkPortUseStatus ----- ${target_proc} ---- ${target_port} ----"
	if [ 0 != `netstat -nutlp | grep "${target_port}" | grep "${target_ip}" | grep "${target_proc}" | wc -l` ]; then
		#echo "I'm listening"
		return "${SERVICE_RUNNING}"
	else
		#echo "I'm not get..."
		return "${PORT_NOT_LISTEN}"
	fi > /dev/null
}

check_single_port()
{
	local config_key=$1
	local port_section=$2
	local target_address=$3

	local port=`${GET_SECTION_KEY_VALUE} "${MAILPLUS_SERVER_PORT_PATH}" "${port_section}" dst.ports | awk -F"/" 'NR == 1 {print $1}'`
	if [ -z "${port}" ] ; then
		return "${SERVICE_UNKNOWN}"
	fi

	checkConfKey "${config_key}"
	local conf_enable=$?
	if [ "${config_key}" == "imap_enabled" ] && [ ${conf_enable} -eq "${RUNKEY_DISABLE}" ]; then
		#IMAP always enable on localhost
		checkPortUseStatus "dovecot" "${port}" "127.0.0.1"
		local status=$?
		if [ "${SERVICE_RUNNING}" -ne ${status} ] ; then
			return ${status}
		fi
	fi

	if [ "${RUNKEY_ENABLE}" -eq "${conf_enable}" ]; then
		checkDovecotPortUseStatus "${DOVECOT_NAME}" "${port}" "${target_address}"
		local status=$?
		if [ "${SERVICE_RUNNING}" -ne ${status} ] ; then
			return ${status}
		fi
	else
		checkDovecotPortUseStatus "${DOVECOT_NAME}" "${port}" "${target_address}"
		local status=$?
		if [ "${PORT_NOT_LISTEN}" -ne ${status} ] ; then
			return "${PORT_LISTEN}"
		fi
	fi

	return "${SERVICE_RUNNING}"
}

check_cluster_port()
{
	local config_key=$1
	local port_section=$2
	local target_address=$3

	local port=`${GET_SECTION_KEY_VALUE} "${MAILPLUS_SERVER_PORT_PATH}" "${port_section}" dst.ports | awk -F"/" 'NR == 1 {print $1}'`
	if [ -z "${port}" ] ; then
		return "${SERVICE_UNKNOWN}"
	fi

	checkConfKey "${config_key}"
	local conf_enable=$?
	if [ "${config_key}" == "imap_enabled" ]; then
		#IMAP always enable on localhost
		checkPortUseStatus "dovecot" "${port}" "127.0.0.1"
		local status=$?
		if [ "${SERVICE_RUNNING}" -ne ${status} ] ; then
			return ${status}
		fi
	else
		if [ "${RUNKEY_ENABLE}" -eq ${conf_enable} ]; then
			checkPortUseStatus "dovecot" "${port}" "127.0.0.1"
			local status=$?
			if [ "${SERVICE_RUNNING}" -ne ${status} ] ; then
				return ${status}
			fi
		else
			checkPortUseStatus "dovecot" "${port}" "127.0.0.1"
			local status=$?
			if [ "${PORT_NOT_LISTEN}" -ne ${status} ] ; then
				return "${PORT_LISTEN}"
			fi
		fi
	fi

	if [ "${RUNKEY_ENABLE}" -eq ${conf_enable} ]; then
		checkDovecotPortUseStatus "${DOVECOT_NAME}" "${port}" "${target_address}"
		local status=$?
		if [ "${SERVICE_RUNNING}" -ne ${status} ] ; then
			return ${status}
		fi
	else
		checkDovecotPortUseStatus "${DOVECOT_NAME}" "${port}" "${target_address}"
		local status=$?
		if [ "${PORT_NOT_LISTEN}" -ne ${status} ] ; then
			return "${PORT_LISTEN}"
		fi
	fi

	return "${SERVICE_RUNNING}"
}

bin_status()
{
	checkDovecotStatus "${DOVECOT_NAME}" "${DOVECOT_PID}" "director"
	return $?
}

port_cluster_status()
{
	local nodeIP="$(getHostIP)"
	if [ x"" == x"${nodeIP}" ] ; then
		return "${SERVICE_UNKNOWN}"
	fi

	#Always running
	check_cluster_port "imap_enabled" "mail_imap" "${nodeIP}"
	local imap_status=$?
	if [ "${SERVICE_RUNNING}" -ne ${imap_status} ] && [ "${PORT_LISTEN}" -ne ${imap_status} ]; then
		return ${imap_status}
	fi

	check_cluster_port "imaps_enabled" "mail_imaps" "${nodeIP}"
	local imaps_status=$?
	if [ "${SERVICE_RUNNING}" -ne ${imaps_status} ]; then
		return ${imaps_status}
	fi

	check_cluster_port "pop3_enabled" "mail_pop3" "${nodeIP}"
	local pop3_status=$?
	if [ "${SERVICE_RUNNING}" -ne ${pop3_status} ]; then
		return ${pop3_status}
	fi

	check_cluster_port "pop3s_enabled" "mail_pop3s" "${nodeIP}"
	local pop3s_status=$?
	if [ "${SERVICE_RUNNING}" -ne ${pop3s_status} ]; then
		return ${pop3s_status}
	fi

	return "${SERVICE_RUNNING}"
}

port_single_status()
{
	#Always running
	check_single_port "imap_enabled" "mail_imap" "0.0.0.0"
	local imap_status=$?
	if [ "${SERVICE_RUNNING}" -ne ${imap_status} ] && [ "${PORT_LISTEN}" -ne ${imap_status} ]; then
		return ${imap_status}
	fi

	check_single_port "imaps_enabled" "mail_imaps" "0.0.0.0"
	local imaps_status=$?
	if [ "${SERVICE_RUNNING}" -ne ${imaps_status} ]; then
		return ${imaps_status}
	fi

	check_single_port "pop3_enabled" "mail_pop3" "0.0.0.0"
	local pop3_status=$?
	if [ "${SERVICE_RUNNING}" -ne ${pop3_status} ]; then
		return ${pop3_status}
	fi

	check_single_port "pop3s_enabled" "mail_pop3s" "0.0.0.0"
	local pop3s_status=$?
	if [ "${SERVICE_RUNNING}" -ne ${pop3s_status} ]; then
		return ${pop3s_status}
	fi

	return "${SERVICE_RUNNING}"
}

port_status()
{
	local enable_balancer_address="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "enable_balancer_address")"
	if [ x"${enable_balancer_address}" == x"no" ]; then
		port_single_status
	else
		port_cluster_status
	fi
}

conf_status()
{
#Because dovecot localhost:143 always running
	return "${RUNKEY_ENABLE}"

#	checkConfKey "imap_enabled"
#	if [ ${RUNKEY_ENABLE} -eq $? ]; then
#		return ${RUNKEY_ENABLE}
#	fi
#	checkConfKey "imaps_enabled"
#	if [ ${RUNKEY_ENABLE} -eq $? ]; then
#		return ${RUNKEY_ENABLE}
#	fi
#	checkConfKey "pop3_enabled"
#	if [ ${RUNKEY_ENABLE} -eq $? ]; then
#		return ${RUNKEY_ENABLE}
#	fi
#	checkConfKey "pop3s_enabled"
#	if [ ${RUNKEY_ENABLE} -eq $? ]; then
#		return ${RUNKEY_ENABLE}
#	fi
#	return ${RUNKEY_DISABLE}
}

status()
{
	conf_status
	local dovecot_enable=$?
	bin_status
	local dovecot_status=$?

	if [ "${SERVICE_NOT_RUNNING}" -eq ${dovecot_status} ] && [ "${RUNKEY_DISABLE}" -ne "${dovecot_enable}" ]; then
		return "${SERVICE_UNKNOWN}"
	elif [ "${SERVICE_RUNNING}" -eq ${dovecot_status} ] && [ "${RUNKEY_ENABLE}" -ne "${dovecot_enable}" ]; then
		return "${SERVICE_UNKNOWN}"
	fi
	if [ "${SERVICE_RUNNING}" -ne ${dovecot_status} ]; then
		return ${dovecot_status}
	fi

	port_status
	local dovecot_port=$?
	return ${dovecot_port}
}


start() {
	echo "Starting Dovecot..."
	${DOVECOT_GROUP_CACHE_UPGRADE} "generate" &
	local daemon_status=""
	${DOVECOT_BIN}
	for i in `seq 0 1 "${MAX_TRY_TIMES}"`
	do
		status
		daemon_status=$?
		debug_log "daemon_status dovecot: ${daemon_status}"
		if [ ${daemon_status} -eq "${SERVICE_RUNNING}" ]; then
			#binary is ready
			return 0
		elif [ ${daemon_status} -eq "${SERVICE_DEAD_FPID}" ]; then
			#[FIXME] Maybe we can do something to recover
			return 1
		else
			sleep "${SLEEP_TIME}"
		fi
	done
	return 1
}

check_indexer_worker_stopped() {
	for i in `seq 0 1 "${MAX_TRY_TIMES}"`
	do
		if ! pidof indexer-worker > /dev/null; then
			# all indexer-worker are terminated
			break
		fi
		sleep "${SLEEP_TIME}"
	done

	# if indexer-worker still exists, force stop it
	if pidof indexer-worker > /dev/null; then
		killall -9 indexer-worker
	fi
}

stop() {
	[ -e "${DOVECOT_PID}" ] || return 0
	${DOVEADM_BIN} stop
	check_indexer_worker_stopped
	${DOVECOT_GROUP_CACHE_UPGRADE} "delete"
}

restart()
{
	local rmReplicatorDB="$1"
	stop
	if [ "${rmReplicatorDB}" == "remove_replicator_db" ]; then
		rm -fr "/var/lib/dovecot/replicator.db"
	fi
	sleep 1
	start
}

composePort()
{
	local ports=()
	local port=""

	#imap always on
	ports[${#ports[*]}]=143

	checkConfKey "imaps_enabled"
	if [ "${RUNKEY_ENABLE}" -eq $? ]; then
		port=$(get_port "mail_imaps")
		if [ x"${port}" != x"" ]; then
			ports[${#ports[*]}]=${port}
		else
			err_log "ports imaps get fail"
		fi
	fi

	checkConfKey "pop3_enabled"
	if [ "${RUNKEY_ENABLE}" -eq $? ]; then
		port=$(get_port "mail_pop3")
		if [ x"${port}" != x"" ]; then
			ports[${#ports[*]}]=${port}
		else
			err_log "ports pop3 get fail"
		fi
	fi

	checkConfKey "pop3s_enabled"
	if [ "${RUNKEY_ENABLE}" -eq $? ]; then
		port=$(get_port "mail_pop3s")
		if [ x"${port}" != x"" ]; then
			ports[${#ports[*]}]=${port}
		else
			err_log "ports pop3s get fail"
		fi
	fi
	echo "$(IFS=, ; echo "${ports[*]}")"
}

composeIP()
{
	local nodeIP="$(getHostIP)"
	local enable_balancer_address="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "enable_balancer_address")"
	if [ "${enable_balancer_address}" == "no" ]; then
		echo "0.0.0.0"
	else
		echo "${nodeIP},127.0.0.1"
	fi
}

composeProtocol()
{
	echo "tcp"
}

composePID()
{
	local pid=$(cat "${DOVECOT_PID}" | sed -e 's/^[[:space:]]*//' -e 's/[[:space:]]*$//')
	echo "${pid}"
}

composeScript()
{
	echo "/var/packages/MailPlus-Server/target/scripts/daemon/dovecot.sh"
}

composeOpt()
{
	#[TODO] Maybe we have better solution, like return IP:port pair instead of using option.
	checkConfKey "imap_enabled"
	if [ "${RUNKEY_ENABLE}" -ne $? ]; then
		echo "imap_disable"
	else
		echo ""
	fi
}


case "$1" in
	start)
		startOperation "mailserver_service_dovecot"
		;;
	restart)
		restartOperation "mailserver_service_dovecot" "$@"
		;;
	stop)
		stopOperation "mailserver_service_dovecot"
		;;
	status)
		status
		;;
	*)
		echo "Usage: $0 {start|stop|restart|status}" >&2
		exit 1
		;;
esac
