#!/bin/sh

###############################################################
#	This script should be hooked when invoking SYNOUserSet()
#	Usable environment variable:
#		NITEMS, ORIGIN_USER_NAME_{n}, USER_NAME_{n}, UID_{n},
#		USER_OP_RESULT_{n}, RESULT
#
#	Note: The script should bear to be invoked multiple times
###############################################################

. /var/packages/MailPlus-Server/target/scripts/MailPlusServerCommon

MAIL_SERVER_PKG="/var/packages/MailPlus-Server"
HOOK="${MAIL_SERVER_PKG}/target/hook/AliasUserUpdate.sh"
ACTIVE_DB_HOOK="${MAIL_SERVER_PKG}/target/hook/LicenseUserUpdate.sh"
POLICY_HOOK="${MAIL_SERVER_PKG}/target/hook/UserGroupPolicyUserUpdate.sh"
DISCLAIMER_HOOK="${MAIL_SERVER_PKG}/target/hook/DisclaimerUserUpdate.sh"
DOVECOT_GROUP_CACHE_UPGRADE="${MAIL_SERVER_PKG}/target/bin/syno_gen_dovecot_group_cache"

case $1 in
	--sdk-mod-ver)
		#Print SDK support version
		echo "${SDK_MOD_VER}";
		;;
	--name)
		#Print package name
		echo "${MAIL_SERVER_PKG_NAME}";
		;;
	--pkg-ver)
		#Print package version
		echo "${MAIL_SERVER_PKG_VERSION}";
		;;
	--vendor)
		#Print package vendor
		echo "${MAIL_SERVER_PKG_VENDOR}";
		;;
	--pre)
		if ! checkAccountType; then #exit if account does not match
			exit 0
		fi
		${HOOK} --pre &
		${ACTIVE_DB_HOOK} --pre &
		${POLICY_HOOK} --pre &
		${DISCLAIMER_HOOK} --pre &
		;;
	--post)
		if ! checkAccountType; then #exit if account does not match
			exit 0
		fi
		${HOOK} --post &
		${ACTIVE_DB_HOOK} --post &
		${POLICY_HOOK} --post &
		${DISCLAIMER_HOOK} --post &
		${DOVECOT_GROUP_CACHE_UPGRADE} "generate" &
		;;
	*)
		echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
		;;
esac
