#!/bin/sh

###############################################################
#	This script should be hooked when invoking SYNOGroupSet()
#	Usable environment variable:
#		ORIGIN_GROUP_NAME, GROUP_NAME, and RESULT
#
#	Note: The script should bear to be invoked multiple times
###############################################################

. /var/packages/MailPlus-Server/target/scripts/MailPlusServerCommon
MAIL_SERVER_PKG="/var/packages/MailPlus-Server"
HOOK="${MAIL_SERVER_PKG}/target/hook/AliasGroupUpdate.sh"
ACTIVE_DB_HOOK="${MAIL_SERVER_PKG}/target/hook/LicenseGroupUpdate.sh"
POLICY_HOOK="${MAIL_SERVER_PKG}/target/hook/UserGroupPolicyGroupUpdate.sh"
DOVECOT_GROUP_CACHE_UPGRADE="${MAIL_SERVER_PKG}/target/bin/syno_gen_dovecot_group_cache"

if [ x"MailPlus-Server" == x"${ORIGIN_GROUP_NAME}" ]; then
	#Do nothing because in start/stop script will add one user to MailPlus-Server group
	#And it will trigger group set hook but at that time cluster may not be created.
	#And user will not reach the MailPlus Server group, so we skip it
	exit 0
fi

case $1 in
	--sdk-mod-ver)
		#Print SDK support version
		echo "${SDK_MOD_VER}";
		;;
	--name)
		#Print package name
		echo "${MAIL_SERVER_PKG_NAME}";
		;;
	--pkg-ver)
		#Print package version
		echo "${MAIL_SERVER_PKG_VERSION}";
		;;
	--vendor)
		#Print package vendor
		echo "${MAIL_SERVER_PKG_VENDOR}";
		;;
	--pre)
		if ! checkAccountType; then #exit if account does not match
			exit 0
		fi
		${HOOK} --pre "${ORIGIN_GROUP_NAME}" "${GROUP_NAME}" &
		${ACTIVE_DB_HOOK} --pre "${ORIGIN_GROUP_NAME}" "${GROUP_NAME}" &
		${POLICY_HOOK} --pre "${ORIGIN_GROUP_NAME}" "${GROUP_NAME}" &
		;;
	--post)
		if ! checkAccountType; then #exit if account does not match
			exit 0
		fi
		${HOOK} --post "${ORIGIN_GROUP_NAME}" "${GROUP_NAME}" &
		${ACTIVE_DB_HOOK} --post "${ORIGIN_GROUP_NAME}" "${GROUP_NAME}" &
		${POLICY_HOOK} --post "${ORIGIN_GROUP_NAME}" "${GROUP_NAME}" &
		${DOVECOT_GROUP_CACHE_UPGRADE} "generate" &
		;;
	*)
		echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
		;;
esac
