#!/bin/sh

. /var/packages/MailPlus-Server/target/scripts/MailPlusServerCommon
. /var/packages/MailPlus-Server/target/scripts/daemon/util.sh

HOOK_DIR="/var/packages/MailPlus-Server/target/hook"
DIR_SRV_HOOK="${HOOK_DIR}/dir_service_hook"

SYNO_MAILPLUS_SERVERD_SCRIPT="/var/packages/MailPlus-Server/target/scripts/daemon/syno_mailserverd.sh"
DOVECOT_GROUP_CACHE_UPGRADE="${MAIL_SERVER_PKG}/target/bin/syno_gen_dovecot_group_cache"

case $1 in
	--sdk-mod-ver)
		${DIR_SRV_HOOK} --sdk-mod-ver;
		;;
	--name)
		#Print package name
		echo "${MAIL_SERVER_PKG_NAME}";
		;;
	--vendor)
		#Print package vendor
		echo "${MAIL_SERVER_PKG_VERSION}";
		;;
	--pre)
		;;
	--post)
		#check result of refresh
		if [ "0" != "${RESULT}" ]; then
			exit 0;
		fi

		#check if the package is enabled
		if [ ! -e "${MAIL_SERVER_PKG_ENABLE}" ]; then
			exit 0;
		fi

		#check if syno_mailserverd is running. If not start it
		${SYNO_MAILPLUS_SERVERD_SCRIPT} status
		if [ "${SERVICE_RUNNING}" -ne $? ]; then
			${SYNO_MAILPLUS_SERVERD_SCRIPT} start
		fi

		# Send HUP to rebuild alias and valid db
		PROCESS_PID=`${SYNO_MAILPLUS_SERVERD_SCRIPT} pid`
		kill -HUP "${PROCESS_PID}"
		${DOVECOT_GROUP_CACHE_UPGRADE} "generate" &
		;;
	*)
	;;
esac
