#!/bin/sh
. /var/packages/MailPlus-Server/target/backend_hook/hookUtils.conf
loadEnv

## Check identity
NODE_ID=$(getHostID)
storage_servers="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "storager")"

LOCAL_DOMAIN_NAME="@local"

if ! containString "${NODE_ID}" "${storage_servers}"; then
	exit 0
fi

VOLUME_CONFIG_KEY="general_storage_volume-${NODE_ID}"
STORAGE_VOLUME="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "${VOLUME_CONFIG_KEY}")"

if [ "${STORAGE_VOLUME}" == "" ]; then
	err_log "There are no storage volume"
	exit 0
fi

PACKAGE="MailPlus-Server"
PACKAGE_DIR="/var/packages/${PACKAGE}"
MAILDIR="Maildir"
ACL_AMEND_BIN="${PACKAGE_DIR}/target/bin/syno_acl_amend"

GetMailHome() {
	## Get current domain
	local accountType="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "account_type")"
	local domainName=""

	if [ "${accountType}" == "win" ]; then
		domainName="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "win_domain_short_name")"
	elif [ "${accountType}" == "ldap" ]; then
		domainName="$(${MAILPLUS_SERVER_BACKEND_BINARY} --getConfKeyVal "acc_domain_name")"
	else
		domainName="${LOCAL_DOMAIN_NAME}"
	fi

	if [ "${domainName}" == "" ]; then
		err_log "It cannot get domain"
		return 1
	fi

	if [ ! -d "/${STORAGE_VOLUME}/${MAIL_SHARE_NAME}/${domainName}" ]; then
		err_log "It cannot get mailhome"
		return 1
	fi

	echo "/${STORAGE_VOLUME}/${MAIL_SHARE_NAME}/${domainName}"
	return 0
}

PrintTargetPath() {
	local MailHome=""
	if ! MailHome=$(GetMailHome); then
		err_log "It cannot get mailhome"
		return 1;
	fi
	maildir_list=$(find ${MailHome} -mindepth 3 -maxdepth 3 -type d -name ${MAILDIR})
    (
        IFS=$'\n'
        for dir in ${maildir_list}
        do
            echo "${dir}"
        done
    )
	mailbox_list=$(find ${MailHome} -mindepth 4 -maxdepth 4 -type d)
    (
        IFS=$'\n'
        for dir in ${mailbox_list}
        do
            echo "${dir}"
        done
    )
}

TransferACL() {
	local MailHome=""
	if ! MailHome=$(GetMailHome); then
		err_log "It cannot get mailhome"
		return 1;
	fi
	maildir_list=$(find ${MailHome} -mindepth 3 -maxdepth 3 -type d -name ${MAILDIR})
    (
        IFS=$'\n'
        for dir in ${maildir_list}
        do
             ${ACL_AMEND_BIN} -d "${dir}"
        done
    )
	mailbox_list=$(find ${MailHome} -mindepth 4 -maxdepth 4 -type d)
    (
        IFS=$'\n'
        for dir in ${mailbox_list}
        do
             ${ACL_AMEND_BIN} -m "${dir}"
        done
    )
}

while [ -n "$1" ]; do
case "$1" in
	"-d" | "--debug")
		PrintTargetPath
		exit 1
	;;
	*)
		echo "unhandled option '$1'"
		exit 1
	;;
esac
shift
done

if TransferACL; then
	exit 0
fi
exit 1
