package MailPlusServer::Disclaimer;

use strict;
use warnings;
use Encode;
use Sys::Syslog;
use Encode;
use utf8;

use Data::Dumper;
use Net::IDN::Encode qw/domain_to_ascii/;

sub new {
	my $class = shift;
	my $config = shift;
	my $self = {};

	openlog("$class", 'pid', 'mail');

	$self->{gid_username_map} = $config->{gid_username_map};
	$self->{local_domain_map} = $config->{local_domain_map};
	$self->{disclaimer_list}  = $config->{disclaimer_list};

	bless ($self, $class);
	return $self;
}

sub DESTROY {
	my ($self) = @_;

	closelog();
}

sub get_disclaimer {
	my ($self, $Sender, $RecipientListRef) = @_;
	my $SenderName = '';
	my $SenderDomain = '';

	my %local_domain_map = %{$self->{local_domain_map}};
	my %gid_username_map = %{$self->{gid_username_map}};

	my $has_disclaimer = 0;
	my $content_txt = '';
	my $content_html = '';
	my $all_local_recipient = 1;

	$Sender =~ s/^<//;
	$Sender =~ s/>$//;

	if ($Sender =~ /^(.*)@(.*?)$/) {
		$SenderName = $1;
		$SenderDomain = $2;
	}

	if ($SenderDomain ne '') {
		$SenderDomain = domain_to_ascii($SenderDomain);
		$Sender = $SenderName . '@' . $SenderDomain;
	}

	# check whether it is a outbound mail
	if (!exists($local_domain_map{lc $SenderDomain})) {
		# not outbond mail, so no disclaimer
		return (0, '', '');
	}

	# check whether all recipients are local recipients
	foreach my $Recipient (@{$RecipientListRef}) {
		$Recipient =~ s/^<//;
		$Recipient =~ s/>$//;

		my $RecipientDomain = '';
		if ($Recipient =~ /^.*@(.*?)$/) {
			$RecipientDomain = $1;
		}

		if (!exists($local_domain_map{lc $RecipientDomain})) {
			$all_local_recipient = 0;
			last;
		}
	}

	CHECK_LOOP:
	foreach my $disclaimer (@{$self->{disclaimer_list}}) {
		if ($all_local_recipient && $disclaimer->{disabled_for_local_recipient}) {
			next;
		}

		foreach (@{$RecipientListRef}) {
			# syslog('ERR', "Sender: '$Sender'");
			# syslog('ERR', "Recipient: '$Recipient'");
			my $Recipient = '';
			my $RecipientName = '';
			my $RecipientDomain = '';

			if ($_ =~ /^(.*)@(.*?)$/) {
				$RecipientName = $1;
				$RecipientDomain = $2;
			}

			if ($RecipientDomain ne '') {
				$RecipientDomain = domain_to_ascii($RecipientDomain);
				$Recipient = $RecipientName . '@' . $RecipientDomain;
			}

			my $match;
			my $eval_str = "\$match = $disclaimer->{condition}; 1;";
			eval($eval_str) or do {
				syslog('ERR', "Failed to eval condition: '$disclaimer->{condition}', $@");
			};
			next if !$match;

			$has_disclaimer = 1;
			$content_txt = $disclaimer->{content_txt};
			$content_html = $disclaimer->{content_html};
			last CHECK_LOOP;
		}
	}

	if ($has_disclaimer) {
		$content_txt = Encode::encode_utf8($content_txt);
		$content_html = Encode::encode_utf8($content_html);
	}
	return ($has_disclaimer, $content_txt, $content_html);
}

1;
