#!/bin/sh

SetInterface()
{
	. /var/packages/MailPlus-Server/target/backend_hook/hookUtils.conf
	local HOST_IF=`${MAILPLUS_SERVER_BACKEND_BINARY} --getHostIF`
	if [[ "${SLAVES}" =~ (^|,)${HOST_IF}($|,) ]]; then
		local HOST_ID=`${MAILPLUS_SERVER_BACKEND_BINARY} --getHostID`
		if [ -z "${HOST_ID}" ]; then
			log "[Bond Change] empty host id"
			return 1
		fi
		local NEW_IP="$(getInterfaceIP "${MASTER}")"
		if [ -z "${NEW_IP}" ]; then
			log "[Bond Change] cant not get ip of interface [${MASTER}]"
			return 1
		fi
		## update backend config and mapping table
		if ! ${MAILPLUS_SERVER_BACKEND_BINARY} --mappingRegen "${NEW_IP}"; then
			log "[MailPlusServerBondCreate] - Failed to regen mailplus server id-ip mapping table"
		fi
		local KEY="node_bind_if-${HOST_ID}"
		if ! ${MAILPLUS_SERVER_BACKEND_BINARY} --setConfKeyVal "${KEY}" "${MASTER}"; then
			log "[MailPlusServerBondCreate] - Failed to set the new interface"
		fi
	fi
	return 0
}

case $1 in
	--sdk-mod-ver)
	#Print SDK support version
	echo "1.0";
	;;
	--name)
	#Print package name
	echo "MailPlus-Server";
	;;
	--pkg-ver)
	#Print package version
	echo "1.0";
	;;
	--vendor)
	#Print package vendor
	echo "Synology";
	;;
	--pre)
	;;
	--post)
		if [ "${ACTION}" == "create" ]; then
			SetInterface
		fi
	;;
	*)
	echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
	;;
esac
