#!/bin/sh

###############################################################
#   This script should be hooked when invoking user delete
#   Usable environment variable:
#       NITEMS, USER_NAME_X, USER_OP_RESULT_X, RESULT
###############################################################

#Include common scripts
. /var/packages/MailPlus-Server/target/scripts/MailPlusServerCommon

#At begining, acquire package settings
PackageInfoGet;

MAIL_SERVER_PKG="/var/packages/MailPlus-Server"
MailServerBackend="${MAIL_SERVER_PKG}/target/bin/syno_mailserver_backend"

case $1 in
	--sdk-mod-ver)
		#Print SDK support version
		echo "${SDK_MOD_VER}";
		;;
	--name)
		#Print package name
		echo "${MAIL_SERVER_PKG_NAME}";
		;;
	--pkg-ver)
		#Print package version
		echo "${MAIL_SERVER_PKG_VERSION}";
		;;
	--vendor)
		#Print package vendor
		echo "${MAIL_SERVER_PKG_VENDOR}";
		;;
	--pre)
		#noop
		;;
	--post)
		usr_idx=1;
		usr_cnt=$(($NITEMS + 1));
		personal_keys=($($MailServerBackend --getTree personal | jq 'keys[]'))

		while [ "$usr_idx" != "$usr_cnt" ]
		do
		eval "uid=\$UID_$usr_idx"
		eval "usr_name=\$USER_NAME_$usr_idx"

			if [ ! -z "$uid" ]; then
				remove_keys=($(printf "%s\n" ${personal_keys[@]} | grep "personal-$uid-"))
				for key in ${remove_keys[@]}; do
					eval $(echo "$MailServerBackend --deleteFileByKey $key")
					if [ 0 != $? ]; then
						err_log "[CleanupUserDelete]: failed to delete $key of $usr_name"
					fi
				done
			fi
			usr_idx=$(($usr_idx + 1));
		done
		;;
	*)
	echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
		;;
esac
