#!/bin/sh

PERSONAL_SETTING=0
MigrateForward()
{
	local forward="${SRC_DIR}/.forward"
	if [ -f ${forward} ];then
		PERSONAL_SETTING=1
		cp -a "${forward}" "${DEST_DIR}/"
		sed -i -e "s|/var/packages/MailServer/target/bin/vacation|/var/packages/MailPlus-Server/target/bin/vacation|g" "${DEST_DIR}/.forward"
	fi
}

MigrateAutoReply()
{
	cp -a ${SRC_DIR}/.*.msg "${DEST_DIR}/"
}

while getopts "s:d:u:" opt; do
case "${opt}" in
	s)
		SRC_DIR=${OPTARG}
		;;
	d)
		DEST_DIR=${OPTARG}
		;;
	u)
		USERNAME=${OPTARG}
		;;
	*)
		exit 0;;
esac
done

if [ x"${SRC_DIR}" = x"" -o x"${DEST_DIR}" = x"" -o x"${USERNAME}" = x"" ]; then
	exit -1;
fi

MigrateForward

MigrateAutoReply

if [ 1 = ${PERSONAL_SETTING} ];
then
	echo "${USERNAME}" >> /tmp/mailplus_server/migration_personal.list
fi
